/*
 * Decompiled with CFR 0.152.
 */
package com.chemastudios.ecorecolector;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.widget.ArrayAdapter;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.android.volley.Request;
import com.android.volley.toolbox.JsonObjectRequest;
import com.android.volley.toolbox.Volley;
import com.chemastudios.ecorecolector.Producto;
import com.chemastudios.ecorecolector.ProductoAdapterv1;
import com.chemastudios.ecorecolector.R;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.textfield.TextInputEditText;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class DetalleSolicitudActivityV1
extends AppCompatActivity {
    private static final String TAG = "DetalleSolicitudV1";
    private TextView txtNombreUsuario;
    private TextView txtDireccionUsuario;
    private TextView txtTelefonoUsuario;
    private TextInputEditText edtUsuarioId;
    private TextInputEditText edtKilos;
    private TextView txtPuntos;
    private TextView txtTotal;
    private Spinner spnCategoria;
    private MaterialButton btnAgregar;
    private MaterialButton btnEnviar;
    private RecyclerView recyclerView;
    private List<Producto> listaProductos = new ArrayList<Producto>();
    private ProductoAdapterv1 adapter;
    private double puntosPorKilo = 0.5;
    private double totalPuntos = 0.0;
    private double totalKilos = 0.0;
    private String[] categorias = new String[]{"Pl\u00e1stico", "Cart\u00f3n", "Vidrio", "Metal", "Org\u00e1nico", "Electr\u00f3nicos"};
    private String idSolicitud = "";
    private String idUsuario = "";
    private static final String URL_GUARDAR = "http://74.208.75.82/guardarProductos.php";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_detalle_solicitud);
        this.txtNombreUsuario = (TextView)this.findViewById(R.id.txtNombreUsuariov1);
        this.txtDireccionUsuario = (TextView)this.findViewById(R.id.txtDireccionUsuario);
        this.txtTelefonoUsuario = (TextView)this.findViewById(R.id.txtTelefonoUsuario);
        this.edtUsuarioId = (TextInputEditText)this.findViewById(R.id.edtUsuarioId);
        this.edtKilos = (TextInputEditText)this.findViewById(R.id.edtKilosv1);
        this.txtPuntos = (TextView)this.findViewById(R.id.txtPuntosv1);
        this.txtTotal = (TextView)this.findViewById(R.id.txtTotalv1);
        this.spnCategoria = (Spinner)this.findViewById(R.id.spnCategoria);
        this.btnAgregar = (MaterialButton)this.findViewById(R.id.btnAgregar);
        this.btnEnviar = (MaterialButton)this.findViewById(R.id.btnGuardarv1);
        this.recyclerView = (RecyclerView)this.findViewById(R.id.recyclerProductos);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.adapter = new ProductoAdapterv1(this.listaProductos, position -> this.borrarProducto(position));
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        ArrayAdapter adapterSp = new ArrayAdapter((Context)this, 0x1090009, (Object[])this.categorias);
        this.spnCategoria.setAdapter((SpinnerAdapter)adapterSp);
        this.idSolicitud = this.getIntent().getStringExtra("idSolicitud");
        if (this.idSolicitud == null || this.idSolicitud.trim().isEmpty()) {
            Toast.makeText((Context)this, (CharSequence)"Error: solicitud sin ID", (int)0).show();
            this.finish();
            return;
        }
        String nombre = this.getIntent().getStringExtra("nombre");
        String direccion = this.getIntent().getStringExtra("direccion");
        String ciudad = this.getIntent().getStringExtra("ciudad");
        String colonia = this.getIntent().getStringExtra("colonia");
        String cp = this.getIntent().getStringExtra("cp");
        String numeroCasa = this.getIntent().getStringExtra("numeroCasa");
        String telefono = this.getIntent().getStringExtra("telefono");
        String idUsuarioRecibido = this.getIntent().getStringExtra("idUsuario");
        String direccionCompleta = direccion + ", " + numeroCasa + ", " + colonia + ", " + ciudad + ", CP: " + cp;
        this.txtNombreUsuario.setText((CharSequence)("Nombre: " + (nombre != null ? nombre : "Desconocido")));
        this.txtDireccionUsuario.setText((CharSequence)("Direcci\u00f3n: " + direccionCompleta));
        this.txtTelefonoUsuario.setText((CharSequence)("Tel\u00e9fono: " + (telefono != null && !telefono.isEmpty() ? telefono : "No disponible")));
        if (idUsuarioRecibido != null && !idUsuarioRecibido.isEmpty()) {
            this.edtUsuarioId.setText((CharSequence)idUsuarioRecibido);
            this.idUsuario = idUsuarioRecibido;
        }
        this.btnAgregar.setOnClickListener(v -> this.agregarProducto());
        this.btnEnviar.setOnClickListener(v -> this.enviarProductos());
        this.actualizarTextos();
    }

    private void actualizarTextos() {
        this.txtPuntos.setText((CharSequence)"Puntos: 0");
        this.txtTotal.setText((CharSequence)("Total puntos: " + this.totalPuntos + " | Kilos: " + this.totalKilos));
    }

    private void agregarProducto() {
        double kilos;
        String kilosText = this.edtKilos.getText().toString().trim();
        if (kilosText.isEmpty()) {
            Toast.makeText((Context)this, (CharSequence)"Ingresa los kilos", (int)0).show();
            return;
        }
        try {
            kilos = Double.parseDouble(kilosText);
        }
        catch (NumberFormatException e) {
            Toast.makeText((Context)this, (CharSequence)"Kilos inv\u00e1lidos", (int)0).show();
            return;
        }
        if (kilos <= 0.0) {
            Toast.makeText((Context)this, (CharSequence)"Kilos debe ser mayor que 0", (int)0).show();
            return;
        }
        double puntos = kilos * this.puntosPorKilo;
        String categoria = this.spnCategoria.getSelectedItem().toString();
        Producto p = new Producto(categoria, kilos, puntos);
        this.listaProductos.add(p);
        this.totalPuntos += puntos;
        this.totalKilos += kilos;
        this.txtPuntos.setText((CharSequence)("Puntos: " + puntos));
        this.txtTotal.setText((CharSequence)("Total puntos: " + this.totalPuntos + " | Kilos: " + this.totalKilos));
        this.adapter.notifyItemInserted(this.listaProductos.size() - 1);
        this.edtKilos.setText((CharSequence)"");
        this.edtKilos.requestFocus();
        this.recyclerView.post(() -> this.recyclerView.smoothScrollToPosition(this.listaProductos.size() - 1));
    }

    private void borrarProducto(int position) {
        if (position < 0 || position >= this.listaProductos.size()) {
            return;
        }
        Producto eliminado = this.listaProductos.get(position);
        this.totalPuntos -= eliminado.getPuntosv();
        this.totalKilos -= eliminado.getKilos();
        this.listaProductos.remove(position);
        this.adapter.notifyItemRemoved(position);
        this.txtTotal.setText((CharSequence)("Total puntos: " + this.totalPuntos + " | Kilos: " + this.totalKilos));
    }

    private void enviarProductos() {
        String userIdText = this.edtUsuarioId.getText().toString().trim();
        if (userIdText.isEmpty()) {
            Toast.makeText((Context)this, (CharSequence)"ID usuario no disponible", (int)0).show();
            return;
        }
        this.idUsuario = userIdText;
        if (this.listaProductos.isEmpty()) {
            Toast.makeText((Context)this, (CharSequence)"No hay productos agregados", (int)0).show();
            return;
        }
        try {
            JSONObject json = new JSONObject();
            json.put("id_solicitud", (Object)this.idSolicitud);
            json.put("id_usuario", (Object)this.idUsuario);
            json.put("total_puntos", this.totalPuntos);
            json.put("total_kilos", this.totalKilos);
            JSONArray array2 = new JSONArray();
            for (Producto p : this.listaProductos) {
                JSONObject obj = new JSONObject();
                obj.put("categoria", (Object)p.getCategoria());
                obj.put("kilos", p.getKilos());
                obj.put("puntos", p.getPuntosv());
                array2.put((Object)obj);
            }
            json.put("productos", (Object)array2);
            this.enviarProductosAPI(json);
        }
        catch (Exception e) {
            Toast.makeText((Context)this, (CharSequence)"Error interno", (int)0).show();
            e.printStackTrace();
        }
    }

    private void enviarProductosAPI(JSONObject json) {
        JsonObjectRequest jsonObjectRequest = new JsonObjectRequest(1, URL_GUARDAR, json, response -> {
            Log.d((String)TAG, (String)("RESPONSE: " + response.toString()));
            try {
                boolean success = response.getBoolean("success");
                String msg = response.getString("msg");
                double totalPuntosResp = response.optDouble("total_puntos", 0.0);
                double totalKilosResp = response.optDouble("total_kilos", 0.0);
                Toast.makeText((Context)this, (CharSequence)(msg + "\nTotal puntos: " + totalPuntosResp + " | Total kilos: " + totalKilosResp), (int)1).show();
                if (success) {
                    this.finish();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Toast.makeText((Context)this, (CharSequence)"\u274c Respuesta inv\u00e1lida", (int)0).show();
            }
        }, error -> {
            Log.e((String)TAG, (String)("\u274c Error guardando productos: " + error.toString()));
            if (error.networkResponse != null) {
                Log.e((String)TAG, (String)("STATUS: " + error.networkResponse.statusCode));
                Log.e((String)TAG, (String)("DATA: " + new String(error.networkResponse.data)));
            }
            Toast.makeText((Context)this, (CharSequence)"\u274c Error guardando productos", (int)1).show();
        }){

            public Map<String, String> getHeaders() {
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Content-Type", "application/json; charset=UTF-8");
                return headers;
            }
        };
        Volley.newRequestQueue((Context)this).add((Request)jsonObjectRequest);
    }
}

