/*
 * Decompiled with CFR 0.152.
 */
package com.chemastudios.ecorecolector;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.RetryPolicy;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;
import com.chemastudios.ecorecolector.CanjeoActivity;
import com.chemastudios.ecorecolector.HistorialSolicitudesActivity;
import com.chemastudios.ecorecolector.InicioDeSeccion;
import com.chemastudios.ecorecolector.MenuPrincipalActivity;
import com.chemastudios.ecorecolector.PerfilActivity;
import com.chemastudios.ecorecolector.R;
import com.chemastudios.ecorecolector.SessionManager;
import com.chemastudios.ecorecolector.SolicitudActivity;
import com.chemastudios.ecorecolector.VerMasReciclaje;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.json.JSONObject;

public class MainActivity
extends AppCompatActivity {
    private TextView txtPuntosAcumulados;
    private TextView txtKilosReciclados;
    private static final String URL_API_STATS = "http://74.208.75.82/api/get_user_stats.php";
    private final Handler handler = new Handler();
    private static final int INTERVALO_ACTUALIZACION = 5000;
    private final Runnable refrescarDatos = new Runnable(){

        @Override
        public void run() {
            MainActivity.this.cargarEstadisticasUsuario();
            MainActivity.this.handler.postDelayed((Runnable)this, 5000L);
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.inicio_app);
        View root = this.findViewById(R.id.rootMain);
        Animation fade = AnimationUtils.loadAnimation((Context)this, (int)R.anim.fade_in_modern);
        root.startAnimation(fade);
        this.txtPuntosAcumulados = (TextView)this.findViewById(R.id.txtPuntosAcumulados);
        this.txtKilosReciclados = (TextView)this.findViewById(R.id.txtKilosReciclados);
        ImageView iconHistorial = (ImageView)this.findViewById(R.id.ichistoriallppp);
        iconHistorial.setOnClickListener(v -> this.startActivity(new Intent((Context)this, HistorialSolicitudesActivity.class)));
        ImageView iconPremios = (ImageView)this.findViewById(R.id.icpremiospppl);
        iconPremios.setOnClickListener(v -> this.startActivity(new Intent((Context)this, CanjeoActivity.class)));
        ImageView iconPerfil = (ImageView)this.findViewById(R.id.iconProfile);
        iconPerfil.setOnClickListener(v -> this.startActivity(new Intent((Context)this, PerfilActivity.class)));
        ImageView iconMenu = (ImageView)this.findViewById(R.id.iconMenu);
        iconMenu.setOnClickListener(v -> this.startActivity(new Intent((Context)this, MenuPrincipalActivity.class)));
        Button btnVerMasReciclaje = (Button)this.findViewById(R.id.btnVerMasReciclaje);
        btnVerMasReciclaje.setOnClickListener(v -> this.startActivity(new Intent((Context)this, VerMasReciclaje.class)));
        this.validarSesion();
        this.mostrarMensajeBienvenida();
        this.cargarEstadisticasUsuario();
        View btnSolicitar = this.findViewById(R.id.btnSolicitar);
        btnSolicitar.setOnClickListener(v -> this.startActivity(new Intent((Context)this, SolicitudActivity.class)));
    }

    protected void onResume() {
        super.onResume();
        this.handler.post(this.refrescarDatos);
    }

    protected void onPause() {
        super.onPause();
        this.handler.removeCallbacks(this.refrescarDatos);
    }

    private void validarSesion() {
        if (SessionManager.getUserId() <= 0) {
            this.redirigirALogin();
        }
    }

    private void mostrarMensajeBienvenida() {
        boolean yaMostrado;
        String nombre = SessionManager.getUserName();
        if (nombre == null || nombre.trim().isEmpty() || nombre.equalsIgnoreCase("null")) {
            nombre = "Eco H\u00e9roe";
        }
        if (!(yaMostrado = this.getSharedPreferences("APP_PREFS", 0).getBoolean("bienvenida_mostrada", false))) {
            this.showWelcome(nombre);
            this.getSharedPreferences("APP_PREFS", 0).edit().putBoolean("bienvenida_mostrada", true).apply();
        }
    }

    private void redirigirALogin() {
        this.handler.removeCallbacks(this.refrescarDatos);
        Intent intent = new Intent((Context)this, InicioDeSeccion.class);
        intent.setFlags(0x10008000);
        this.startActivity(intent);
        this.finish();
    }

    private void cargarEstadisticasUsuario() {
        final int userId = SessionManager.getUserId();
        if (userId <= 0) {
            Toast.makeText((Context)this, (CharSequence)"No hay sesi\u00f3n activa.", (int)1).show();
            this.redirigirALogin();
            return;
        }
        RequestQueue queue = Volley.newRequestQueue((Context)this);
        StringRequest stringRequest = new StringRequest(1, URL_API_STATS, response -> {
            try {
                JSONObject jsonResponse = new JSONObject(response);
                boolean error = jsonResponse.optBoolean("error", true);
                if (!error) {
                    JSONObject userStats = jsonResponse.optJSONObject("user");
                    if (userStats != null) {
                        String puntosStr = userStats.optString("puntos", "0");
                        this.txtPuntosAcumulados.setText((CharSequence)puntosStr);
                        String kilosStr = userStats.optString("kilos_reciclados", "0.00");
                        try {
                            double kilosDouble = Double.parseDouble(kilosStr);
                            this.txtKilosReciclados.setText((CharSequence)String.format(Locale.US, "%.2f KG", kilosDouble));
                        }
                        catch (NumberFormatException e) {
                            this.txtKilosReciclados.setText((CharSequence)"0.00 KG");
                        }
                    }
                } else {
                    Toast.makeText((Context)this, (CharSequence)"No se pudo cargar informaci\u00f3n", (int)0).show();
                }
            }
            catch (Exception e) {
                Toast.makeText((Context)this, (CharSequence)"Error al procesar datos", (int)1).show();
            }
        }, error -> Toast.makeText((Context)this, (CharSequence)"Error de conexi\u00f3n", (int)1).show()){

            protected Map<String, String> getParams() {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("user_id", String.valueOf(userId));
                return params;
            }
        };
        stringRequest.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(5000, 1, 1.0f));
        queue.add((Request)stringRequest);
    }

    private void showWelcome(String usuario) {
        LayoutInflater inflater = LayoutInflater.from((Context)this);
        View layout2 = inflater.inflate(R.layout.welcome_popup, null);
        TextView txtWelcome = (TextView)layout2.findViewById(R.id.txtWelcomev1);
        txtWelcome.setText((CharSequence)("\u00a1Bienvenido " + usuario + "!"));
        FrameLayout root = (FrameLayout)this.findViewById(0x1020002);
        root.addView(layout2);
        Animation animIn = AnimationUtils.loadAnimation((Context)this, (int)R.anim.welcome_in);
        Animation animOut = AnimationUtils.loadAnimation((Context)this, (int)R.anim.welcome_out);
        txtWelcome.startAnimation(animIn);
        new Handler().postDelayed(() -> {
            txtWelcome.startAnimation(animOut);
            new Handler().postDelayed(() -> root.removeView(layout2), 600L);
        }, 1500L);
    }
}

