/*
 * Decompiled with CFR 0.152.
 */
package com.chemastudios.ecorecolector;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.RetryPolicy;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;
import com.chemastudios.ecorecolector.EsperaActivity;
import com.chemastudios.ecorecolector.R;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class SolicitudActivity
extends AppCompatActivity {
    private EditText etNombre;
    private EditText etDireccion;
    private EditText etCiudad;
    private EditText etColonia;
    private EditText etCP;
    private EditText etNumeroCasa;
    private EditText etReferencia;
    private Button btnEnviar;
    private static final String URL_CREATE_SOLICITUD = "http://74.208.75.82/api/create_solicitud.php";
    private static final String SHARED_PREFS_NAME = "userData";
    private static final String PREFS_USER_ID_KEY = "user_id";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_solicitud);
        this.etNombre = (EditText)this.findViewById(R.id.etNombre);
        this.etDireccion = (EditText)this.findViewById(R.id.etDireccion);
        this.etCiudad = (EditText)this.findViewById(R.id.etCiudad);
        this.etColonia = (EditText)this.findViewById(R.id.etColonia);
        this.etCP = (EditText)this.findViewById(R.id.etCP);
        this.etNumeroCasa = (EditText)this.findViewById(R.id.etNumeroCasa);
        this.etReferencia = (EditText)this.findViewById(R.id.etReferencia);
        this.btnEnviar = (Button)this.findViewById(R.id.btnEnviarSolicitud);
        this.btnEnviar.setOnClickListener(v -> this.enviarSolicitud());
    }

    private void enviarSolicitud() {
        SharedPreferences prefs = this.getSharedPreferences(SHARED_PREFS_NAME, 0);
        final int userId = prefs.getInt(PREFS_USER_ID_KEY, -1);
        if (userId == -1) {
            Toast.makeText((Context)this, (CharSequence)"No hay sesi\u00f3n activa.", (int)1).show();
            return;
        }
        final String nombre = this.etNombre.getText().toString().trim();
        final String direccion = this.etDireccion.getText().toString().trim();
        final String ciudad = this.etCiudad.getText().toString().trim();
        final String colonia = this.etColonia.getText().toString().trim();
        final String cp = this.etCP.getText().toString().trim();
        final String numeroCasa = this.etNumeroCasa.getText().toString().trim();
        final String referencia = this.etReferencia.getText().toString().trim();
        if (nombre.isEmpty() || direccion.isEmpty()) {
            Toast.makeText((Context)this, (CharSequence)"Nombre y direcci\u00f3n son obligatorios.", (int)1).show();
            return;
        }
        if (!ciudad.equalsIgnoreCase("Ciudad Guzm\u00e1n")) {
            Toast.makeText((Context)this, (CharSequence)"Solo se permite Ciudad Guzm\u00e1n.", (int)1).show();
            return;
        }
        this.btnEnviar.setEnabled(false);
        RequestQueue queue = Volley.newRequestQueue((Context)this);
        StringRequest request = new StringRequest(1, URL_CREATE_SOLICITUD, response -> {
            this.btnEnviar.setEnabled(true);
            try {
                JSONObject jsonResponse = new JSONObject(response);
                if (!jsonResponse.getBoolean("error")) {
                    int idSolicitud = jsonResponse.getInt("id_solicitud");
                    Toast.makeText((Context)this, (CharSequence)("Solicitud creada. ID: " + idSolicitud), (int)1).show();
                    Intent intent = new Intent((Context)this, EsperaActivity.class);
                    intent.putExtra("idSolicitud", String.valueOf(idSolicitud));
                    this.startActivity(intent);
                    this.finish();
                } else {
                    Toast.makeText((Context)this, (CharSequence)("Error: " + jsonResponse.getString("message")), (int)1).show();
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
                Toast.makeText((Context)this, (CharSequence)"Error en la respuesta del servidor o JSON inv\u00e1lido.", (int)1).show();
            }
        }, error -> {
            this.btnEnviar.setEnabled(true);
            Toast.makeText((Context)this, (CharSequence)"Error de conexi\u00f3n. Revisa tu internet o el servidor.", (int)1).show();
        }){

            protected Map<String, String> getParams() {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("id_usuario", String.valueOf(userId));
                params.put("nombre", nombre);
                params.put("direccion", direccion);
                params.put("ciudad", ciudad);
                params.put("colonia", colonia);
                params.put("cp", cp);
                params.put("numero_casa", numeroCasa);
                params.put("referencia", referencia);
                return params;
            }

            public String getBodyContentType() {
                return "application/x-www-form-urlencoded; charset=UTF-8";
            }
        };
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(10000, 1, 1.0f));
        queue.add((Request)request);
    }
}

