package com.chemastudios.ecorecolector;

import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;
import android.util.Log;

import com.android.volley.Request;
import com.android.volley.toolbox.JsonArrayRequest;
import com.android.volley.toolbox.Volley;

import org.json.JSONObject;
import org.json.JSONException;

import java.util.ArrayList;

public class HistorialSolicitudesActivityV1 extends AppCompatActivity {

    private static final String TAG = "EcoRecolectorHistorial";

    RecyclerView recyclerView;
    TextView txtNoSolicitudes;
    ArrayList<Solicitud> listaSolicitudes;
    HistorialSolicitudesAdapterV1 adapter;

    String URL = "http://74.208.75.82/api/getSolicitudes.php";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_historial_solicitudes_v1);

        recyclerView = findViewById(R.id.recyclerHistorialSolicitudesV1);
        txtNoSolicitudes = findViewById(R.id.txtNoSolicitudesv1);

        recyclerView.setLayoutManager(new LinearLayoutManager(this));

        listaSolicitudes = new ArrayList<>();
        adapter = new HistorialSolicitudesAdapterV1(listaSolicitudes);

        adapter.setOnItemClickListener(solicitud -> {
            Intent i = new Intent(this, VerMapa.class);

            i.putExtra("idSolicitud", solicitud.getIdSolicitud());
            i.putExtra("idUsuario", solicitud.getIdUsuario());
            i.putExtra("nombre", solicitud.getNombre());
            i.putExtra("direccion", solicitud.getDireccion());
            i.putExtra("ciudad", solicitud.getCiudad());
            i.putExtra("colonia", solicitud.getColonia());
            i.putExtra("cp", solicitud.getCp());
            i.putExtra("numeroCasa", solicitud.getNumeroCasa());
            i.putExtra("referencia", solicitud.getReferencia());
            i.putExtra("telefono", solicitud.getTelefono());

            startActivity(i);
        });

        recyclerView.setAdapter(adapter);

        cargarSolicitudes();
    }

    private void cargarSolicitudes() {
        Log.d(TAG, "Solicitando GET a: " + URL);

        JsonArrayRequest req = new JsonArrayRequest(
                Request.Method.GET,
                URL,
                null,
                response -> {

                    listaSolicitudes.clear();

                    try {
                        for (int i = 0; i < response.length(); i++) {

                            JSONObject obj = response.getJSONObject(i);

                            String idUsuario = obj.optString("id_usuario", "");
                            String telefono = obj.optString("telefono", ""); // Asegúrate de que tu API tenga "telefono"

                            Solicitud sol = new Solicitud(
                                    obj.optString("id", ""),
                                    obj.optString("nombre", ""),
                                    obj.optString("direccion", ""),
                                    obj.optString("ciudad", ""),
                                    obj.optString("colonia", ""),
                                    obj.optString("cp", ""),
                                    obj.optString("numero_casa", ""),
                                    obj.optString("referencia", ""),
                                    obj.optString("fecha", ""),
                                    obj.optString("estado", ""),
                                    idUsuario,
                                    telefono
                            );

                            listaSolicitudes.add(sol);
                        }

                        adapter.notifyDataSetChanged();

                        txtNoSolicitudes.setVisibility(
                                listaSolicitudes.isEmpty() ? View.VISIBLE : View.GONE
                        );

                    } catch (JSONException e) {
                        Log.e(TAG, "Error JSON: " + e.getMessage());
                        Toast.makeText(this, "Error procesando datos", Toast.LENGTH_SHORT).show();
                    }

                },
                error -> {
                    Log.e(TAG, "Error Volley: " + error.toString());
                    Toast.makeText(this, "Error cargando datos", Toast.LENGTH_SHORT).show();
                }
        );

        Volley.newRequestQueue(this).add(req);
    }
}
