package com.chemastudios.ecorecolector;

import android.content.Intent;
import android.os.Bundle;
import android.widget.Button;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;

import com.android.volley.Request;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;

import java.util.HashMap;
import java.util.Map;

public class CanjeoActivity extends AppCompatActivity {

    int puntosUsuario = 0;

    String URL_PUNTOS = "http://74.208.75.82/api/get_puntos_canjeo.php?id=";
    String URL_CANJEAR = "http://74.208.75.82/api/canjear_producto.php";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.item_producto);

        SessionManager.init(this);

        cargarPuntosServidor(() -> {

            configurarBoton(R.id.btnCanjearProd1, 100, "Lapicero ecológico");
            configurarBoton(R.id.btnCanjearProd2, 125, "Bolsa de algodón");
            configurarBoton(R.id.btnCanjearProd3, 800, "Kit bambú");
            configurarBoton(R.id.btnCanjearProd4, 150, "Semillas");
            configurarBoton(R.id.btnCanjearProd5, 450, "Cepillo bambú");
            configurarBoton(R.id.btnCanjearProd6, 1200, "Termo acero");
            configurarBoton(R.id.btnCanjearProd7, 600, "Pasta sólida");
            configurarBoton(R.id.btnCanjearProd8, 2000, "Funda compostable");
            configurarBoton(R.id.btnCanjearProd9, 1950, "Shampoo sólido");
            configurarBoton(R.id.btnCanjearProd10, 1690, "Filtro café");

        });
    }

    private void cargarPuntosServidor(Runnable callback) {

        int idUsuario = SessionManager.getUserId();

        if (idUsuario == -1) {
            Toast.makeText(this, "No hay sesión activa", Toast.LENGTH_SHORT).show();
            finish();
            return;
        }

        String url = URL_PUNTOS + idUsuario;

        StringRequest req = new StringRequest(Request.Method.GET, url,
                resp -> {
                    try {
                        puntosUsuario = Integer.parseInt(resp.trim());

                        if (puntosUsuario <= 0) {
                            Toast.makeText(this, "Aún no tienes puntos", Toast.LENGTH_SHORT).show();
                        }

                        callback.run();

                    } catch (Exception e) {
                        Toast.makeText(this, "Error leyendo puntos", Toast.LENGTH_SHORT).show();
                    }
                },
                error -> Toast.makeText(this, "Error al cargar puntos", Toast.LENGTH_SHORT).show()
        );

        Volley.newRequestQueue(this).add(req);
    }


    /** ✅ Configurar botones */
    private void configurarBoton(int idBtn, int costo, String nombreProd) {

        Button btn = findViewById(idBtn);

        btn.setOnClickListener(v -> {
            if (puntosUsuario < costo) {
                Toast.makeText(this, "No tienes suficientes puntos", Toast.LENGTH_SHORT).show();
                return;
            }

            // Abrimos la pantalla para llenar datos
            Intent i = new Intent(this, ConfirmarDatosActivity.class);
            i.putExtra("producto", nombreProd);
            i.putExtra("costo", costo);
            startActivity(i);
        });
    }

    /** ✅ FUNCIÓN PARA DESCONTAR AL CONFIRMAR */
    public void descontarPuntos(int costo) {

        int idUsuario = SessionManager.getUserId();

        StringRequest req = new StringRequest(Request.Method.POST, URL_CANJEAR,
                resp -> {
                    if (resp.contains("OK")) {
                        puntosUsuario -= costo;
                        Toast.makeText(this, "✅ Canje realizado", Toast.LENGTH_SHORT).show();
                    } else {
                        Toast.makeText(this, "❌ Error al canjear", Toast.LENGTH_SHORT).show();
                    }
                },
                error -> Toast.makeText(this, "❌ Error servidor", Toast.LENGTH_SHORT).show()
        ) {
            @Override
            protected Map<String, String> getParams() {
                Map<String, String> p = new HashMap<>();
                p.put("id_usuario", String.valueOf(idUsuario));
                p.put("costo", String.valueOf(costo));
                return p;
            }
        };

        Volley.newRequestQueue(this).add(req);
    }
}
