package com.chemastudios.ecorecolector;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;

public class HistorialSolicitudesAdapterV1 extends RecyclerView.Adapter<HistorialSolicitudesAdapterV1.ViewHolder> {

    ArrayList<Solicitud> lista;
    OnItemClickListener listener;

    public interface OnItemClickListener {
        void onItemClick(Solicitud solicitud);
    }

    public void setOnItemClickListener(OnItemClickListener listener){
        this.listener = listener;
    }

    public HistorialSolicitudesAdapterV1(ArrayList<Solicitud> lista) {
        this.lista = lista;
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View v = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.item_solicitud_v1, parent, false);
        return new ViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {

        Solicitud s = lista.get(position);

        holder.txtNombre.setText(s.getNombre());
        holder.txtDireccion.setText(s.getDireccion());
        holder.txtFecha.setText(s.getFechaCreacion());
        holder.txtEstado.setText(s.getEstado());
        holder.txtIdUsuario.setText("ID Usuario: " + s.getIdUsuario());

        holder.itemView.setOnClickListener(v -> {
            if (listener != null) listener.onItemClick(s);
        });
    }

    @Override
    public int getItemCount() {
        return lista.size();
    }

    public static class ViewHolder extends RecyclerView.ViewHolder {

        TextView txtNombre, txtDireccion, txtFecha, txtEstado, txtIdUsuario;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);

            txtNombre = itemView.findViewById(R.id.txtNombreV1);
            txtDireccion = itemView.findViewById(R.id.txtDireccionV1);
            txtFecha = itemView.findViewById(R.id.txtFechaV1);
            txtEstado = itemView.findViewById(R.id.txtEstadoV1);
            txtIdUsuario = itemView.findViewById(R.id.txtIdUsuarioV1);
        }
    }
}

