package com.chemastudios.ecorecolector;

import android.content.Context;
import android.content.SharedPreferences;

/**
 * Clase estática para mantener datos de sesión de corta duración (en memoria).
 * Utilizada para acceso rápido al ID, nombre y tipo de usuario logueado.
 */
public class SessionManager {

    // ✅ NUEVO → Nombre de preferencias
    private static final String PREF_NAME = "userData";
    private static final String KEY_USER_ID = "user_id";
    private static final String KEY_USER_NAME = "user_name";
    private static final String KEY_USER_TYPE = "user_type";

    // Variables estáticas (persisten mientras la app siga viva en RAM)
    private static String userName = "Eco Héroe";
    private static int userId = -1;
    private static String userType = "usuario"; // "usuario" o "recolector"

    /** ✅ NUEVO: Cargar valores desde SharedPreferences */
    public static void init(Context context) {
        SharedPreferences sp = context.getSharedPreferences(PREF_NAME, Context.MODE_PRIVATE);
        userName = sp.getString(KEY_USER_NAME, "Eco Héroe");
        userId = sp.getInt(KEY_USER_ID, -1);
        userType = sp.getString(KEY_USER_TYPE, "usuario");
    }

    // ----------- GETTERS -----------

    public static String getUserName() {
        return userName;
    }

    public static int getUserId() {
        return userId;
    }

    public static String getUserType() {
        return userType;
    }

    // ----------- SETTERS -----------

    public static void setUserName(Context context, String name) {
        // Evita valores null, vacío o "null" literal
        if (name != null && !name.trim().isEmpty() && !name.equalsIgnoreCase("null")) {
            userName = name;
        } else {
            userName = "Eco Héroe";
        }

        save(context, KEY_USER_NAME, userName);
    }

    public static void setUserId(Context context, int id) {
        userId = id;
        save(context, KEY_USER_ID, id);
    }

    public static void setUserType(Context context, String type) {
        if (type != null && !type.trim().isEmpty()) {
            userType = type;
        } else {
            userType = "usuario";
        }

        save(context, KEY_USER_TYPE, userType);
    }

    /** ✅ NUEVO: Guardado en SharedPreferences */
    private static void save(Context context, String key, Object value) {
        SharedPreferences sp = context.getSharedPreferences(PREF_NAME, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sp.edit();

        if (value instanceof Integer) editor.putInt(key, (Integer) value);
        if (value instanceof String) editor.putString(key, (String) value);

        editor.apply();
    }

    /**
     * Limpia todos los datos en memoria y restablece valores por defecto.
     */
    public static void clearSession(Context context) {
        userName = "Eco Héroe";
        userId = -1;
        userType = "usuario";

        context.getSharedPreferences(PREF_NAME, Context.MODE_PRIVATE)
                .edit()
                .clear()
                .apply();
    }
}
