package com.chemastudios.ecorecolector;

import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.util.Log;

import com.android.volley.Request;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;
import com.google.firebase.encoders.json.BuildConfig;

import org.json.JSONObject;

public class VersionChecker {

    public interface Callback {
        void onOk();        // ✅ versión válida
        void onRequireUpdate(String msg, String url);  // ❌ requiere update
    }

    public static void check(Context context, String urlVersionFile, Callback callback) {

        StringRequest request = new StringRequest(Request.Method.GET, urlVersionFile,
                response -> {
                    try {
                        JSONObject obj = new JSONObject(response);

                        int latestVersion = obj.getInt("versionCode");
                        String url = obj.optString("url", "");
                        String msg = obj.optString("message", "Nueva versión disponible");

                        int localVersion = BuildConfig.VERSION_CODE;

                        Log.d("VersionCheck", "Local: " + localVersion + " | Server: " + latestVersion);

                        if (localVersion >= latestVersion) {
                            callback.onOk();
                        } else {
                            callback.onRequireUpdate(msg, url);
                        }

                    } catch (Exception e) {
                        callback.onOk();
                    }
                },
                error -> {
                    callback.onOk();
                });

        Volley.newRequestQueue(context).add(request);
    }

    public static void showUpdateDialog(Context context, String msg, String url) {
        new AlertDialog.Builder(context)
                .setTitle("Actualización requerida")
                .setMessage(msg)
                .setCancelable(false)
                .setPositiveButton("Actualizar", (dialog, which) -> {
                    context.startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse(url)));
                })
                .show();
    }
}
