package com.chemastudios.ecorecolector;

import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import android.content.SharedPreferences;
import android.os.Bundle;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;

import com.android.volley.Request;
import com.android.volley.toolbox.JsonArrayRequest;
import com.android.volley.toolbox.Volley;

import org.json.JSONObject;
import org.json.JSONException;

import java.util.ArrayList;

public class HistorialSolicitudesActivity extends AppCompatActivity {

    RecyclerView recyclerView;
    TextView txtVacio;
    ArrayList<Solicitud> listaSolicitudes;
    HistorialSolicitudesAdapterV1 adapter;

    private static final String SHARED_PREFS_NAME = "userData";
    private static final String PREFS_USER_ID_KEY = "user_id";

    String URL = "http://74.208.75.82/api/verSolicitudes.php";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_historial_solicitudes);

        recyclerView = findViewById(R.id.recyclerHistorialSolicitudesV1);
        txtVacio = findViewById(R.id.txtVacioHistorial);

        recyclerView.setLayoutManager(new LinearLayoutManager(this));

        listaSolicitudes = new ArrayList<>();
        adapter = new HistorialSolicitudesAdapterV1(listaSolicitudes);

        recyclerView.setAdapter(adapter);

        cargarSolicitudes();
    }

    private void cargarSolicitudes() {

        SharedPreferences prefs = getSharedPreferences(SHARED_PREFS_NAME, MODE_PRIVATE);
        int idStored = prefs.getInt(PREFS_USER_ID_KEY, -1);

        if (idStored == -1) {
            Toast.makeText(this, "Usuario no encontrado", Toast.LENGTH_SHORT).show();
            txtVacio.setVisibility(View.VISIBLE);
            recyclerView.setVisibility(View.GONE);
            return;
        }

        String finalURL = URL + "?user_id=" + idStored;

        JsonArrayRequest req = new JsonArrayRequest(
                Request.Method.GET,
                finalURL,
                null,
                response -> {

                    listaSolicitudes.clear();

                    if (response.length() == 0) {
                        txtVacio.setVisibility(View.VISIBLE);
                        recyclerView.setVisibility(View.GONE);
                        return;
                    }

                    try {
                        for (int i = 0; i < response.length(); i++) {

                            JSONObject obj = response.getJSONObject(i);

                            // Pasar el IdUsuario desde el JSON o usar el idStored si el JSON no lo trae
                            String idUsuario = obj.optString("id_usuario", String.valueOf(idStored));

                            Solicitud solicitud = new Solicitud(
                                    obj.optString("id", ""),
                                    obj.optString("nombre", ""),
                                    obj.optString("direccion", ""),
                                    obj.optString("ciudad", ""),
                                    obj.optString("colonia", ""),
                                    obj.optString("cp", ""),
                                    obj.optString("numero_casa", ""),
                                    obj.optString("referencia", ""),
                                    obj.optString("fecha", ""),
                                    obj.optString("estado", ""),
                                    obj.optString("Numero", ""),
                                    idUsuario
                            );

                            listaSolicitudes.add(solicitud);
                        }

                        adapter.notifyDataSetChanged();

                        txtVacio.setVisibility(View.GONE);
                        recyclerView.setVisibility(View.VISIBLE);

                    } catch (JSONException e) {
                        Toast.makeText(this, "Error al procesar datos", Toast.LENGTH_SHORT).show();
                        txtVacio.setVisibility(View.VISIBLE);
                        recyclerView.setVisibility(View.GONE);
                    }

                },
                error -> {
                    txtVacio.setVisibility(View.VISIBLE);
                    recyclerView.setVisibility(View.GONE);
                    Toast.makeText(this, "Error de red", Toast.LENGTH_SHORT).show();
                }
        );

        Volley.newRequestQueue(this).add(req);
    }
}
