package com.chemastudios.ecorecolector;

import android.content.Intent;
import android.os.Bundle;

import androidx.appcompat.app.AppCompatActivity;

public class MenuPrincipalActivity extends AppCompatActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        // Asegúrate de que este sea el nombre de tu archivo XML de menú limpio
        setContentView(R.layout.menu_lateral);

        // Configuración de los listeners de los botones del menú
        setupMenuListeners();
    }

    private void setupMenuListeners() {
        // Perfil
        findViewById(R.id.btnPerfil).setOnClickListener(v -> navigateTo(PerfilActivity.class));

        // Solicitar Petición
        findViewById(R.id.btnSolicitar1).setOnClickListener(v -> navigateTo(SolicitudActivity.class));

        // Historial
        findViewById(R.id.btnHistorial).setOnClickListener(v -> navigateTo(HistorialSolicitudesActivity.class));

        // Ganar Puntos (Scan QR)
        findViewById(R.id.btnScanQR).setOnClickListener(v -> navigateTo(ScanProductosActivity.class));

        // Canjear Puntos
        findViewById(R.id.btnPuntos).setOnClickListener(v -> navigateTo(CanjeoActivity.class));
    }

    private void navigateTo(Class<?> targetActivity) {
        Intent intent = new Intent(MenuPrincipalActivity.this, targetActivity);
        startActivity(intent);
        // Usa postDelayed para cerrar la actividad después de un pequeño delay
        findViewById(android.R.id.content).postDelayed(this::finish, 50);
    }

    }
