package com.chemastudios.ecorecolector;

import android.os.Bundle;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient; // Necesario para mantener la navegación dentro de la app
import androidx.appcompat.app.AppCompatActivity;

public class NoticiasActivity extends AppCompatActivity {

    private WebView webView;

    // URL que deseas cargar (Aquí usaremos la simulación de tu página de Noticias)
    private static final String NOTICIAS_URL = "http://74.208.75.82/#noticias";
    // Si aún no tienes un dominio real, puedes usar una URL de prueba, o la del proyecto web.

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        // Asignamos el layout que crearemos: activity_noticias.xml
        setContentView(R.layout.activity_noticias);

        // 1. Encontrar el WebView en el layout
        webView = findViewById(R.id.webViewNoticias);

        // 2. Configuración básica del WebView
        WebSettings webSettings = webView.getSettings();
        // Habilitar JavaScript (necesario para la mayoría de las páginas web modernas, incluida tu SPA)
        webSettings.setJavaScriptEnabled(true);
        // Habilitar almacenamiento DOM (útil para SPAs y almacenamiento local)
        webSettings.setDomStorageEnabled(true);

        // 3. Forzar que los enlaces se abran dentro del WebView y no en el navegador externo
        webView.setWebViewClient(new WebViewClient() {
            // Esto asegura que la navegación interna se maneje dentro del WebView.
            @Override
            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                view.loadUrl(url);
                return true;
            }
        });

        // 4. Cargar la URL
        webView.loadUrl(NOTICIAS_URL);
    }

    /**
     * Permite retroceder en el historial del WebView al presionar el botón de "Atrás" del teléfono,
     * en lugar de cerrar inmediatamente la actividad.
     */
    @Override
    public void onBackPressed() {
        if (webView.canGoBack()) {
            webView.goBack();
        } else {
            super.onBackPressed();
        }
    }
}