package com.chemastudios.ecorecolector;

import android.os.Bundle;
import android.os.Handler;
import android.text.Editable;
import android.text.TextWatcher;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;

import com.google.android.libraries.places.api.Places;
import com.google.android.libraries.places.api.model.AutocompletePrediction;
import com.google.android.libraries.places.api.model.AutocompleteSessionToken;
import com.google.android.libraries.places.api.net.FindAutocompletePredictionsRequest;
import com.google.android.libraries.places.api.net.PlacesClient;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

public class Registros extends AppCompatActivity {

    private EditText etNombre, etTelefono, etEmail, etPassword, etConfirmPassword;
    private AutoCompleteTextView etDireccion;
    private Button btnRegistrar;

    private PlacesClient placesClient;
    private ArrayAdapter<String> placesAdapter;
    private final List<String> suggestions = new ArrayList<>();
    private final Handler handler = new Handler();
    private Runnable workRunnable;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.register_app);

        // Inicializar Places API
        if (!Places.isInitialized()) {
            Places.initialize(getApplicationContext(), getString(R.string.google_maps_key));
        }
        placesClient = Places.createClient(this);

        // Referencias UI
        etNombre = findViewById(R.id.etNombre);
        etTelefono = findViewById(R.id.etTelefono);
        etDireccion = findViewById(R.id.etDireccion);
        etEmail = findViewById(R.id.etEmail);
        etPassword = findViewById(R.id.etPassword);
        etConfirmPassword = findViewById(R.id.etConfirmPassword);
        btnRegistrar = findViewById(R.id.btnRegistrar);

        // 🟢 Forzar dominio @ecorecolector.com
        etEmail.addTextChangedListener(new TextWatcher() {
            private boolean editing = false;
            private final String dominio = "@ecorecolector.com";

            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {}

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {}

            @Override
            public void afterTextChanged(Editable s) {
                if (editing) return;
                editing = true;

                String texto = s.toString();
                if (texto.isEmpty()) {
                    editing = false;
                    return;
                }

                if (texto.contains(dominio)) {
                    int indexDominio = texto.indexOf(dominio);
                    if (indexDominio != -1 && etEmail.getSelectionStart() > indexDominio) {
                        etEmail.setSelection(indexDominio);
                    }
                } else {
                    if (texto.contains("@")) {
                        texto = texto.substring(0, texto.indexOf("@"));
                    }
                    etEmail.setText(texto + dominio);
                    etEmail.setSelection(texto.length());
                }

                editing = false;
            }
        });

        // Configurar adaptador de sugerencias para dirección
        placesAdapter = new ArrayAdapter<>(this, android.R.layout.simple_dropdown_item_1line, suggestions);
        etDireccion.setAdapter(placesAdapter);
        etDireccion.setThreshold(1);

        // TextWatcher con debounce para autocompletar dirección
        etDireccion.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {}

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (workRunnable != null) handler.removeCallbacks(workRunnable);
                workRunnable = () -> fetchPlacesPredictions(s.toString());
                handler.postDelayed(workRunnable, 300);
            }

            @Override
            public void afterTextChanged(Editable s) {}
        });

        // Acción de registro
        btnRegistrar.setOnClickListener(v -> registrarUsuario());
    }

    private void fetchPlacesPredictions(String query) {
        if (query.isEmpty()) return;

        AutocompleteSessionToken token = AutocompleteSessionToken.newInstance();
        FindAutocompletePredictionsRequest request = FindAutocompletePredictionsRequest.builder()
                .setSessionToken(token)
                .setQuery(query)
                .build();

        placesClient.findAutocompletePredictions(request)
                .addOnSuccessListener(response -> {
                    suggestions.clear();
                    for (AutocompletePrediction prediction : response.getAutocompletePredictions()) {
                        suggestions.add(prediction.getPrimaryText(null).toString() + " " +
                                prediction.getSecondaryText(null).toString());
                    }
                    placesAdapter.notifyDataSetChanged();
                    etDireccion.showDropDown();
                })
                .addOnFailureListener(e -> {
                    suggestions.clear();
                    placesAdapter.notifyDataSetChanged();
                });
    }

    private void registrarUsuario() {
        String nombre = etNombre.getText().toString().trim();
        String tel = etTelefono.getText().toString().trim();
        String dir = etDireccion.getText().toString().trim();
        String email = etEmail.getText().toString().trim();
        String pass1 = etPassword.getText().toString().trim();
        String pass2 = etConfirmPassword.getText().toString().trim();

        // Validaciones
        if (nombre.isEmpty() || tel.isEmpty() || dir.isEmpty() || email.isEmpty() || pass1.isEmpty() || pass2.isEmpty()) {
            Toast.makeText(this, "Llena todos los campos", Toast.LENGTH_SHORT).show();
            return;
        }

        if (!email.endsWith("@ecorecolector.com")) {
            Toast.makeText(this, "El correo debe terminar en @ecorecolector.com", Toast.LENGTH_SHORT).show();
            return;
        }

        if (!pass1.equals(pass2)) {
            Toast.makeText(this, "Las contraseñas no coinciden", Toast.LENGTH_SHORT).show();
            return;
        }

        // Envío al servidor
        new Thread(() -> {
            try {
                URL url = new URL("http://74.208.75.82/register.php");
                HttpURLConnection conn = (HttpURLConnection) url.openConnection();
                conn.setRequestMethod("POST");
                conn.setDoOutput(true);
                conn.setDoInput(true);

                String data =
                        "nombre=" + URLEncoder.encode(nombre, "UTF-8") +
                                "&telefono=" + URLEncoder.encode(tel, "UTF-8") +
                                "&direccion=" + URLEncoder.encode(dir, "UTF-8") +
                                "&email=" + URLEncoder.encode(email, "UTF-8") +
                                "&password=" + URLEncoder.encode(pass1, "UTF-8");

                OutputStream os = conn.getOutputStream();
                BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
                bw.write(data);
                bw.flush();
                bw.close();
                os.close();

                int responseCode = conn.getResponseCode();

                if (responseCode == HttpURLConnection.HTTP_OK) {
                    BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                    StringBuilder respuesta = new StringBuilder();
                    String linea;
                    while ((linea = br.readLine()) != null) respuesta.append(linea);
                    br.close();

                    runOnUiThread(() -> {
                        Toast.makeText(this, "Registro exitoso: " + respuesta.toString().trim(), Toast.LENGTH_LONG).show();
                        finish();
                    });
                } else {
                    runOnUiThread(() ->
                            Toast.makeText(this, "Error en servidor: " + responseCode, Toast.LENGTH_SHORT).show()
                    );
                }
                conn.disconnect();

            } catch (Exception e) {
                runOnUiThread(() ->
                        Toast.makeText(this, "Error de red/conexión: " + e.getMessage(), Toast.LENGTH_LONG).show()
                );
            }
        }).start();
    }
}
