package com.chemastudios.ecorecolector;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.TextView;
import android.widget.VideoView;

import androidx.appcompat.app.AppCompatActivity;

public class WelcomeSplashActivity extends AppCompatActivity {

    private Handler handler = new Handler(Looper.getMainLooper());
    private Runnable goToMainRunnable;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_welcome_splash);

        TextView tvBienvenida = findViewById(R.id.tvBienvenida);
        VideoView bgVideo = findViewById(R.id.bgVideo);

        // ✅ NOMBRE USUARIO
        String nombre = SessionManager.getUserName();
        if (nombre == null || nombre.trim().isEmpty() || nombre.equals("null")) {
            nombre = "Eco Héroe";
        }
        tvBienvenida.setText("¡Bienvenido!\n" + nombre + "!");

        // ✅ VIDEO
        Uri videoPath = Uri.parse("android.resource://" + getPackageName() + "/" + R.raw.bienvenida_pl);
        bgVideo.setVideoURI(videoPath);

        bgVideo.setOnPreparedListener(mp -> {
            mp.setLooping(true);
            mp.setVolume(0f, 0f);
            bgVideo.start();
        });

        // ✅ ANIMACIONES MÁS PROFESIONALES
        Animation animIn = AnimationUtils.loadAnimation(this, R.anim.splash_enter);
        Animation animOut = AnimationUtils.loadAnimation(this, R.anim.splash_exit);

        tvBienvenida.startAnimation(animIn);

        handler.postDelayed(() -> {
            if (!isFinishing()) tvBienvenida.startAnimation(animOut);
        }, 1600);

        goToMainRunnable = () -> {
            if (!isFinishing()) {
                startActivity(new Intent(WelcomeSplashActivity.this, MainActivity.class));
                finish();
            }
        };

        handler.postDelayed(goToMainRunnable, 2000);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (handler != null && goToMainRunnable != null) {
            handler.removeCallbacks(goToMainRunnable);
        }
    }
}
