/*
 * Decompiled with CFR 0.152.
 */
package com.chemastudios.ecorecolector;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.android.volley.Request;
import com.android.volley.toolbox.JsonArrayRequest;
import com.android.volley.toolbox.Volley;
import com.chemastudios.ecorecolector.HistorialSolicitudesAdapterV1;
import com.chemastudios.ecorecolector.R;
import com.chemastudios.ecorecolector.Solicitud;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;

public class HistorialSolicitudesActivity
extends AppCompatActivity {
    RecyclerView recyclerView;
    TextView txtVacio;
    ArrayList<Solicitud> listaSolicitudes;
    HistorialSolicitudesAdapterV1 adapter;
    private static final String SHARED_PREFS_NAME = "userData";
    private static final String PREFS_USER_ID_KEY = "user_id";
    String URL = "http://74.208.75.82/api/verSolicitudes.php";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_historial_solicitudes);
        this.recyclerView = (RecyclerView)this.findViewById(R.id.recyclerHistorialSolicitudesV1);
        this.txtVacio = (TextView)this.findViewById(R.id.txtVacioHistorial);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.listaSolicitudes = new ArrayList();
        this.adapter = new HistorialSolicitudesAdapterV1(this.listaSolicitudes);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        this.cargarSolicitudes();
    }

    private void cargarSolicitudes() {
        SharedPreferences prefs = this.getSharedPreferences(SHARED_PREFS_NAME, 0);
        int idStored = prefs.getInt(PREFS_USER_ID_KEY, -1);
        if (idStored == -1) {
            Toast.makeText((Context)this, (CharSequence)"Usuario no encontrado", (int)0).show();
            this.txtVacio.setVisibility(0);
            this.recyclerView.setVisibility(8);
            return;
        }
        String finalURL = this.URL + "?user_id=" + idStored;
        JsonArrayRequest req = new JsonArrayRequest(0, finalURL, null, response -> {
            this.listaSolicitudes.clear();
            if (response.length() == 0) {
                this.txtVacio.setVisibility(0);
                this.recyclerView.setVisibility(8);
                return;
            }
            try {
                for (int i = 0; i < response.length(); ++i) {
                    JSONObject obj = response.getJSONObject(i);
                    String idUsuario = obj.optString("id_usuario", String.valueOf(idStored));
                    Solicitud solicitud = new Solicitud(obj.optString("id", ""), obj.optString("nombre", ""), obj.optString("direccion", ""), obj.optString("ciudad", ""), obj.optString("colonia", ""), obj.optString("cp", ""), obj.optString("numero_casa", ""), obj.optString("referencia", ""), obj.optString("fecha", ""), obj.optString("estado", ""), obj.optString("Numero", ""), idUsuario);
                    this.listaSolicitudes.add(solicitud);
                }
                this.adapter.notifyDataSetChanged();
                this.txtVacio.setVisibility(8);
                this.recyclerView.setVisibility(0);
            }
            catch (JSONException e) {
                Toast.makeText((Context)this, (CharSequence)"Error al procesar datos", (int)0).show();
                this.txtVacio.setVisibility(0);
                this.recyclerView.setVisibility(8);
            }
        }, error -> {
            this.txtVacio.setVisibility(0);
            this.recyclerView.setVisibility(8);
            Toast.makeText((Context)this, (CharSequence)"Error de red", (int)0).show();
        });
        Volley.newRequestQueue((Context)this).add((Request)req);
    }
}

