/*
 * Decompiled with CFR 0.152.
 */
package com.chemastudios.ecorecolector;

import android.app.DownloadManager;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.util.Log;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import com.chemastudios.ecorecolector.R;
import com.chemastudios.ecorecolector.RecolectorActivity;
import com.chemastudios.ecorecolector.Registros;
import com.chemastudios.ecorecolector.SessionManager;
import com.chemastudios.ecorecolector.WelcomeSplashActivity;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.json.JSONObject;

public class InicioDeSeccion
extends AppCompatActivity {
    private EditText etEmail;
    private EditText etPassword;
    private Button btnLogin;
    private CheckBox cbRecordarme;
    private SharedPreferences prefs;
    private static final String SHARED_PREFS_NAME = "userData";
    private static final String PREF_EMAIL_KEY = "saved_email";
    private static final String PREF_PASSWORD_KEY = "saved_password";
    private static final String PREF_REMEMBER_CREDS_KEY = "remember_creds";
    private static final String PREFS_USER_ID_KEY = "user_id";
    private static final String PREFS_NOMBRE_KEY = "nombre";
    private static final String PREFS_TIPO_KEY = "tipo";
    private static final String LOGIN_URL = "http://74.208.75.82/login.php";
    private static final String UPDATE_URL = "http://74.208.75.82/version.json";
    private static final int CURRENT_VERSION = 1;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.login_app);
        this.prefs = this.getSharedPreferences(SHARED_PREFS_NAME, 0);
        this.etEmail = (EditText)this.findViewById(R.id.etEmail);
        this.etPassword = (EditText)this.findViewById(R.id.etPassword);
        this.btnLogin = (Button)this.findViewById(R.id.btnLogin);
        this.cbRecordarme = (CheckBox)this.findViewById(R.id.chkRecordar);
        this.cargarCredencialesGuardadas();
        this.verificarActualizacion();
        this.btnLogin.setOnClickListener(v -> this.iniciarSesion());
        TextView tvRegister = (TextView)this.findViewById(R.id.tvRegister);
        TextView tvForgotPassword = (TextView)this.findViewById(R.id.tvForgotPassword);
        tvRegister.setOnClickListener(v -> {
            Intent intent = new Intent((Context)this, Registros.class);
            this.startActivity(intent);
        });
        tvForgotPassword.setOnClickListener(v -> Toast.makeText((Context)this, (CharSequence)"Opci\u00f3n no disponible. Lo siento, necesitas hablar con un administrador para cambiar la contrase\u00f1a.", (int)1).show());
    }

    private void cargarCredencialesGuardadas() {
        boolean rememberCreds = this.prefs.getBoolean(PREF_REMEMBER_CREDS_KEY, false);
        this.cbRecordarme.setChecked(rememberCreds);
        if (rememberCreds) {
            this.etEmail.setText((CharSequence)this.prefs.getString(PREF_EMAIL_KEY, ""));
            this.etPassword.setText((CharSequence)this.prefs.getString(PREF_PASSWORD_KEY, ""));
        } else {
            this.etEmail.setText((CharSequence)"");
            this.etPassword.setText((CharSequence)"");
        }
    }

    private void iniciarSesion() {
        String email = this.etEmail.getText().toString().trim();
        String password = this.etPassword.getText().toString().trim();
        if (email.isEmpty() || password.isEmpty()) {
            Toast.makeText((Context)this, (CharSequence)"Ingresa email y contrase\u00f1a", (int)0).show();
            return;
        }
        boolean shouldRememberCreds = this.cbRecordarme.isChecked();
        this.btnLogin.setEnabled(false);
        new Thread(() -> {
            try {
                URL url = new URL(LOGIN_URL);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("POST");
                conn.setDoInput(true);
                conn.setDoOutput(true);
                String data = "email=" + URLEncoder.encode(email, "UTF-8") + "&password=" + URLEncoder.encode(password, "UTF-8");
                OutputStream os = conn.getOutputStream();
                os.write(data.getBytes(StandardCharsets.UTF_8));
                os.flush();
                os.close();
                int responseCode = conn.getResponseCode();
                if (responseCode == 200) {
                    String line;
                    BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
                    StringBuilder response = new StringBuilder();
                    while ((line = br.readLine()) != null) {
                        response.append(line);
                    }
                    br.close();
                    conn.disconnect();
                    JSONObject json = new JSONObject(response.toString());
                    String status = json.optString("status", "error");
                    if (status.equals("ok")) {
                        JSONObject user = json.optJSONObject("user");
                        if (user == null) {
                            this.runOnUiThread(() -> {
                                Toast.makeText((Context)this, (CharSequence)"Error: Datos de usuario inv\u00e1lidos del servidor.", (int)1).show();
                                this.btnLogin.setEnabled(true);
                            });
                            return;
                        }
                        int userId = user.optInt("id", -1);
                        String nombreUsuario = user.optString(PREFS_NOMBRE_KEY, "");
                        String tipoUsuario = user.optString(PREFS_TIPO_KEY, "");
                        SessionManager.setUserName(nombreUsuario);
                        SessionManager.setUserId(userId);
                        SessionManager.setUserType(tipoUsuario);
                        SharedPreferences.Editor editor = this.prefs.edit();
                        editor.putInt(PREFS_USER_ID_KEY, userId);
                        editor.putString(PREFS_NOMBRE_KEY, nombreUsuario);
                        editor.putString(PREFS_TIPO_KEY, tipoUsuario);
                        editor.putBoolean(PREF_REMEMBER_CREDS_KEY, shouldRememberCreds);
                        if (shouldRememberCreds) {
                            editor.putString(PREF_EMAIL_KEY, email);
                            editor.putString(PREF_PASSWORD_KEY, password);
                        } else {
                            editor.remove(PREF_EMAIL_KEY);
                            editor.remove(PREF_PASSWORD_KEY);
                        }
                        editor.commit();
                        String finalNombreUsuario = nombreUsuario;
                        this.runOnUiThread(() -> {
                            Toast.makeText((Context)this, (CharSequence)("Bienvenido " + finalNombreUsuario), (int)0).show();
                            this.btnLogin.setEnabled(true);
                            if (tipoUsuario.equalsIgnoreCase("recolector")) {
                                this.abrirRecolector();
                            } else {
                                this.abrirHome();
                            }
                        });
                    } else {
                        String msg = json.optString("msg", "Datos incorrectos. Intenta de nuevo.");
                        this.runOnUiThread(() -> {
                            Toast.makeText((Context)this, (CharSequence)msg, (int)0).show();
                            this.btnLogin.setEnabled(true);
                        });
                    }
                } else {
                    this.runOnUiThread(() -> {
                        Toast.makeText((Context)this, (CharSequence)("Error del servidor: C\u00f3digo " + responseCode), (int)0).show();
                        this.btnLogin.setEnabled(true);
                    });
                }
            }
            catch (Exception e) {
                Log.e((String)"LoginError", (String)("Error de conexi\u00f3n o JSON: " + e.getMessage()), (Throwable)e);
                this.runOnUiThread(() -> {
                    Toast.makeText((Context)this, (CharSequence)("Error de conexi\u00f3n: " + e.getMessage()), (int)1).show();
                    this.btnLogin.setEnabled(true);
                });
            }
        }).start();
    }

    private void abrirHome() {
        Intent intent = new Intent((Context)this, WelcomeSplashActivity.class);
        intent.setFlags(0x10008000);
        this.startActivity(intent);
        this.finish();
    }

    private void abrirRecolector() {
        Intent intent = new Intent((Context)this, RecolectorActivity.class);
        intent.setFlags(0x10008000);
        this.startActivity(intent);
        this.finish();
    }

    private void verificarActualizacion() {
        new Thread(() -> {
            try {
                String line;
                URL url = new URL(UPDATE_URL);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.connect();
                BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                StringBuilder result = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    result.append(line);
                }
                br.close();
                JSONObject json = new JSONObject(result.toString());
                int newVersion = json.getInt("versionCode");
                String apkUrl = json.getString("url");
                String message = json.optString("message", "Hay actualizaci\u00f3n disponible");
                if (newVersion > 1) {
                    this.runOnUiThread(() -> {
                        Toast.makeText((Context)this, (CharSequence)message, (int)1).show();
                        this.descargarAPK(apkUrl);
                    });
                }
            }
            catch (Exception e) {
                Log.e((String)"UPDATE", (String)("Error: " + e.getMessage()));
            }
        }).start();
    }

    private void descargarAPK(String urlFile) {
        DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)urlFile));
        request.setTitle((CharSequence)"Actualizando...");
        request.setDescription((CharSequence)"Descargando nueva versi\u00f3n");
        request.setDestinationInExternalPublicDir(Environment.DIRECTORY_DOWNLOADS, "EcoRecolector_v2.apk");
        DownloadManager manager = (DownloadManager)this.getSystemService("download");
        manager.enqueue(request);
    }
}

