/*
 * Decompiled with CFR 0.152.
 */
package com.chemastudios.ecorecolector;

import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.util.Log;
import com.android.volley.Request;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;
import org.json.JSONObject;

public class VersionChecker {
    public static void check(Context context, String urlVersionFile, Callback callback) {
        StringRequest request = new StringRequest(0, urlVersionFile, response -> {
            try {
                JSONObject obj = new JSONObject(response);
                int latestVersion = obj.getInt("versionCode");
                String url = obj.optString("url", "");
                String msg = obj.optString("message", "Nueva versi\u00f3n disponible");
                int localVersion = -1;
                Log.d((String)"VersionCheck", (String)("Local: " + localVersion + " | Server: " + latestVersion));
                if (localVersion >= latestVersion) {
                    callback.onOk();
                } else {
                    callback.onRequireUpdate(msg, url);
                }
            }
            catch (Exception e) {
                callback.onOk();
            }
        }, error -> callback.onOk());
        Volley.newRequestQueue((Context)context).add((Request)request);
    }

    public static void showUpdateDialog(Context context, String msg, String url) {
        new AlertDialog.Builder(context).setTitle((CharSequence)"Actualizaci\u00f3n requerida").setMessage((CharSequence)msg).setCancelable(false).setPositiveButton((CharSequence)"Actualizar", (dialog, which) -> context.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)url)))).show();
    }

    public static interface Callback {
        public void onOk();

        public void onRequireUpdate(String var1, String var2);
    }
}

