/*
 * Decompiled with CFR 0.152.
 */
package com.chemastudios.ecorecolector;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.android.volley.Request;
import com.android.volley.toolbox.JsonArrayRequest;
import com.android.volley.toolbox.Volley;
import com.chemastudios.ecorecolector.HistorialSolicitudesAdapterV1;
import com.chemastudios.ecorecolector.R;
import com.chemastudios.ecorecolector.Solicitud;
import com.chemastudios.ecorecolector.VerMapa;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;

public class HistorialSolicitudesActivityV1
extends AppCompatActivity {
    private static final String TAG = "EcoRecolectorHistorial";
    RecyclerView recyclerView;
    TextView txtNoSolicitudes;
    ArrayList<Solicitud> listaSolicitudes;
    HistorialSolicitudesAdapterV1 adapter;
    String URL = "http://74.208.75.82/api/getSolicitudes.php";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_historial_solicitudes_v1);
        this.recyclerView = (RecyclerView)this.findViewById(R.id.recyclerHistorialSolicitudesV1);
        this.txtNoSolicitudes = (TextView)this.findViewById(R.id.txtNoSolicitudesv1);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.listaSolicitudes = new ArrayList();
        this.adapter = new HistorialSolicitudesAdapterV1(this.listaSolicitudes);
        this.adapter.setOnItemClickListener(solicitud -> {
            Intent i = new Intent((Context)this, VerMapa.class);
            i.putExtra("idSolicitud", solicitud.getIdSolicitud());
            i.putExtra("idUsuario", solicitud.getIdUsuario());
            i.putExtra("nombre", solicitud.getNombre());
            i.putExtra("direccion", solicitud.getDireccion());
            i.putExtra("ciudad", solicitud.getCiudad());
            i.putExtra("colonia", solicitud.getColonia());
            i.putExtra("cp", solicitud.getCp());
            i.putExtra("numeroCasa", solicitud.getNumeroCasa());
            i.putExtra("referencia", solicitud.getReferencia());
            i.putExtra("telefono", solicitud.getTelefono());
            this.startActivity(i);
        });
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        this.cargarSolicitudes();
    }

    private void cargarSolicitudes() {
        Log.d((String)TAG, (String)("Solicitando GET a: " + this.URL));
        JsonArrayRequest req = new JsonArrayRequest(0, this.URL, null, response -> {
            this.listaSolicitudes.clear();
            try {
                for (int i = 0; i < response.length(); ++i) {
                    JSONObject obj = response.getJSONObject(i);
                    String idUsuario = obj.optString("id_usuario", "");
                    String telefono = obj.optString("telefono", "");
                    Solicitud sol = new Solicitud(obj.optString("id", ""), obj.optString("nombre", ""), obj.optString("direccion", ""), obj.optString("ciudad", ""), obj.optString("colonia", ""), obj.optString("cp", ""), obj.optString("numero_casa", ""), obj.optString("referencia", ""), obj.optString("fecha", ""), obj.optString("estado", ""), idUsuario, telefono);
                    this.listaSolicitudes.add(sol);
                }
                this.adapter.notifyDataSetChanged();
                this.txtNoSolicitudes.setVisibility(this.listaSolicitudes.isEmpty() ? 0 : 8);
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)("Error JSON: " + e.getMessage()));
                Toast.makeText((Context)this, (CharSequence)"Error procesando datos", (int)0).show();
            }
        }, error -> {
            Log.e((String)TAG, (String)("Error Volley: " + error.toString()));
            Toast.makeText((Context)this, (CharSequence)"Error cargando datos", (int)0).show();
        });
        Volley.newRequestQueue((Context)this).add((Request)req);
    }
}

