/*
 * Decompiled with CFR 0.152.
 */
package com.chemastudios.ecorecolector;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.TextView;
import android.widget.VideoView;
import androidx.appcompat.app.AppCompatActivity;
import com.chemastudios.ecorecolector.MainActivity;
import com.chemastudios.ecorecolector.R;
import com.chemastudios.ecorecolector.SessionManager;

public class WelcomeSplashActivity
extends AppCompatActivity {
    private Handler handler = new Handler(Looper.getMainLooper());
    private Runnable goToMainRunnable;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_welcome_splash);
        TextView tvBienvenida = (TextView)this.findViewById(R.id.tvBienvenida);
        VideoView bgVideo = (VideoView)this.findViewById(R.id.bgVideo);
        String nombre = SessionManager.getUserName();
        if (nombre == null || nombre.trim().isEmpty() || nombre.equals("null")) {
            nombre = "Eco H\u00e9roe";
        }
        tvBienvenida.setText((CharSequence)("\u00a1Bienvenido!\n" + nombre + "!"));
        Uri videoPath = Uri.parse((String)("android.resource://" + this.getPackageName() + "/" + R.raw.bienvenida_pl));
        bgVideo.setVideoURI(videoPath);
        bgVideo.setOnPreparedListener(mp -> {
            mp.setLooping(true);
            mp.setVolume(0.0f, 0.0f);
            bgVideo.start();
        });
        Animation animIn = AnimationUtils.loadAnimation((Context)this, (int)R.anim.splash_enter);
        Animation animOut = AnimationUtils.loadAnimation((Context)this, (int)R.anim.splash_exit);
        tvBienvenida.startAnimation(animIn);
        this.handler.postDelayed(() -> {
            if (!this.isFinishing()) {
                tvBienvenida.startAnimation(animOut);
            }
        }, 1600L);
        this.goToMainRunnable = () -> {
            if (!this.isFinishing()) {
                this.startActivity(new Intent((Context)this, MainActivity.class));
                this.finish();
            }
        };
        this.handler.postDelayed(this.goToMainRunnable, 2000L);
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.handler != null && this.goToMainRunnable != null) {
            this.handler.removeCallbacks(this.goToMainRunnable);
        }
    }
}

