package com.chemastudios.ecorecolector;

import android.app.DownloadManager;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.util.Log;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;

import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

public class InicioDeSeccion extends AppCompatActivity {

    private EditText etEmail, etPassword;
    private Button btnLogin;
    private CheckBox cbRecordarme;
    private SharedPreferences prefs;

    private static final String SHARED_PREFS_NAME = "userData";
    private static final String PREF_EMAIL_KEY = "saved_email";
    private static final String PREF_PASSWORD_KEY = "saved_password";
    private static final String PREF_REMEMBER_CREDS_KEY = "remember_creds";
    private static final String PREFS_USER_ID_KEY = "user_id";
    private static final String PREFS_NOMBRE_KEY = "nombre";
    private static final String PREFS_TIPO_KEY = "tipo";

    private static final String LOGIN_URL = "http://74.208.75.82/login.php";
    private static final String UPDATE_URL = "http://74.208.75.82/version.json";
    private static final int CURRENT_VERSION = 1;   //  <<<<< AJUSTA AQUÍ TU build.gradle versionCode

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.login_app);

        // Cargar SessionManager desde SharedPreferences (si hay datos)
        SessionManager.init(this);

        prefs = getSharedPreferences(SHARED_PREFS_NAME, MODE_PRIVATE);

        etEmail = findViewById(R.id.etEmail);
        etPassword = findViewById(R.id.etPassword);
        btnLogin = findViewById(R.id.btnLogin);
        cbRecordarme = findViewById(R.id.chkRecordar);

        cargarCredencialesGuardadas();
        verificarActualizacion();   // ✅ <<--- AGREGADO

        btnLogin.setOnClickListener(v -> iniciarSesion());

        TextView tvRegister = findViewById(R.id.tvRegister);
        TextView tvForgotPassword = findViewById(R.id.tvForgotPassword);

        tvRegister.setOnClickListener(v -> {
            Intent intent = new Intent(InicioDeSeccion.this, Registros.class);
            startActivity(intent);
        });

        tvForgotPassword.setOnClickListener(v -> {
            Toast.makeText(InicioDeSeccion.this,
                    "Opción no disponible. Lo siento, necesitas hablar con un administrador para cambiar la contraseña.",
                    Toast.LENGTH_LONG).show();
        });

    }

    private void cargarCredencialesGuardadas() {
        boolean rememberCreds = prefs.getBoolean(PREF_REMEMBER_CREDS_KEY, false);
        cbRecordarme.setChecked(rememberCreds);

        if (rememberCreds) {
            etEmail.setText(prefs.getString(PREF_EMAIL_KEY, ""));
            etPassword.setText(prefs.getString(PREF_PASSWORD_KEY, ""));
        } else {
            etEmail.setText("");
            etPassword.setText("");
        }
    }

    private void iniciarSesion() {
        String email = etEmail.getText().toString().trim();
        String password = etPassword.getText().toString().trim();

        if (email.isEmpty() || password.isEmpty()) {
            Toast.makeText(this, "Ingresa email y contraseña", Toast.LENGTH_SHORT).show();
            return;
        }

        final boolean shouldRememberCreds = cbRecordarme.isChecked();
        btnLogin.setEnabled(false);

        new Thread(() -> {
            try {
                URL url = new URL(LOGIN_URL);
                HttpURLConnection conn = (HttpURLConnection) url.openConnection();
                conn.setRequestMethod("POST");
                conn.setDoInput(true);
                conn.setDoOutput(true);

                String data = "email=" + URLEncoder.encode(email, "UTF-8") +
                        "&password=" + URLEncoder.encode(password, "UTF-8");

                OutputStream os = conn.getOutputStream();
                os.write(data.getBytes(StandardCharsets.UTF_8));
                os.flush();
                os.close();

                int responseCode = conn.getResponseCode();

                if (responseCode == HttpURLConnection.HTTP_OK) {
                    BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
                    StringBuilder response = new StringBuilder();
                    String line;
                    while ((line = br.readLine()) != null) response.append(line);
                    br.close();
                    conn.disconnect();

                    JSONObject json = new JSONObject(response.toString());
                    String status = json.optString("status", "error");

                    if (status.equals("ok")) {
                        JSONObject user = json.optJSONObject("user");
                        if (user == null) {
                            runOnUiThread(() -> {
                                Toast.makeText(InicioDeSeccion.this, "Error: Datos de usuario inválidos del servidor.", Toast.LENGTH_LONG).show();
                                btnLogin.setEnabled(true);
                            });
                            return;
                        }

                        int userId = user.optInt("id", -1);
                        String nombreUsuario = user.optString("nombre", "");
                        String tipoUsuario   = user.optString("tipo", "");

                        // ---- CORRECCIÓN: pasar el Context al SessionManager ----
                        SessionManager.setUserName(InicioDeSeccion.this, nombreUsuario);
                        SessionManager.setUserId(InicioDeSeccion.this, userId);
                        SessionManager.setUserType(InicioDeSeccion.this, tipoUsuario);

                        // Además guardamos en tus SharedPreferences existentes (opcional pero lo conservamos)
                        SharedPreferences.Editor editor = prefs.edit();
                        editor.putInt(PREFS_USER_ID_KEY, userId);
                        editor.putString(PREFS_NOMBRE_KEY, nombreUsuario);
                        editor.putString(PREFS_TIPO_KEY, tipoUsuario);

                        editor.putBoolean(PREF_REMEMBER_CREDS_KEY, shouldRememberCreds);
                        if (shouldRememberCreds) {
                            editor.putString(PREF_EMAIL_KEY, email);
                            editor.putString(PREF_PASSWORD_KEY, password);
                        } else {
                            editor.remove(PREF_EMAIL_KEY);
                            editor.remove(PREF_PASSWORD_KEY);
                        }
                        editor.commit();

                        final String finalNombreUsuario = nombreUsuario;

                        runOnUiThread(() -> {
                            Toast.makeText(InicioDeSeccion.this, "Bienvenido " + finalNombreUsuario, Toast.LENGTH_SHORT).show();

                            btnLogin.setEnabled(true);

                            if (tipoUsuario.equalsIgnoreCase("recolector"))
                                abrirRecolector();
                            else
                                abrirHome();
                        });

                    } else {
                        String msg = json.optString("msg", "Datos incorrectos. Intenta de nuevo.");
                        runOnUiThread(() -> {
                            Toast.makeText(InicioDeSeccion.this, msg, Toast.LENGTH_SHORT).show();
                            btnLogin.setEnabled(true);
                        });
                    }

                } else {
                    runOnUiThread(() -> {
                        Toast.makeText(InicioDeSeccion.this, "Error del servidor: Código " + responseCode, Toast.LENGTH_SHORT).show();
                        btnLogin.setEnabled(true);
                    });
                }

            } catch (Exception e) {
                Log.e("LoginError", "Error de conexión o JSON: " + e.getMessage(), e);
                runOnUiThread(() -> {
                    Toast.makeText(InicioDeSeccion.this, "Error de conexión: " + e.getMessage(), Toast.LENGTH_LONG).show();
                    btnLogin.setEnabled(true);
                });
            }

        }).start();
    }

    private void abrirHome() {
        Intent intent = new Intent(InicioDeSeccion.this, WelcomeSplashActivity.class);
        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK);
        startActivity(intent);
        finish();
    }

    private void abrirRecolector() {
        Intent intent = new Intent(InicioDeSeccion.this, RecolectorActivity.class);
        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK);
        startActivity(intent);
        finish();
    }

    // ✅✅✅ FUNCIÓN AGREGADA – SIN MODIFICAR TU CÓDIGO
    private void verificarActualizacion() {
        new Thread(() -> {
            try {
                URL url = new URL(UPDATE_URL);
                HttpURLConnection conn = (HttpURLConnection) url.openConnection();
                conn.connect();

                BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                StringBuilder result = new StringBuilder();
                String line;
                while ((line = br.readLine()) != null) {
                    result.append(line);
                }
                br.close();

                JSONObject json = new JSONObject(result.toString());
                int newVersion = json.getInt("versionCode");
                String apkUrl = json.getString("url");
                String message = json.optString("message", "Hay actualización disponible");

                if (newVersion > CURRENT_VERSION) {
                    runOnUiThread(() -> {
                        Toast.makeText(this, message, Toast.LENGTH_LONG).show();
                        descargarAPK(apkUrl);
                    });
                }

            } catch (Exception e) {
                Log.e("UPDATE", "Error: " + e.getMessage());
            }

        }).start();
    }

    private void descargarAPK(String urlFile) {
        DownloadManager.Request request = new DownloadManager.Request(Uri.parse(urlFile));
        request.setTitle("Actualizando...");
        request.setDescription("Descargando nueva versión");
        request.setDestinationInExternalPublicDir(Environment.DIRECTORY_DOWNLOADS, "EcoRecolector_v2.apk");

        DownloadManager manager = (DownloadManager) getSystemService(DOWNLOAD_SERVICE);
        manager.enqueue(request);
    }
}
