/*
 * Decompiled with CFR 0.152.
 */
package com.chemastudios.ecorecolector;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import com.android.volley.Request;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;
import com.chemastudios.ecorecolector.R;
import com.google.android.material.textfield.TextInputEditText;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class PerfilActivity
extends AppCompatActivity {
    private TextView tvNombre;
    private TextView txtEmail;
    private TextView txtFecha;
    private TextInputEditText etTelefono;
    private TextInputEditText etDireccion;
    private TextInputEditText etPuntos;
    private TextInputEditText etKilos;
    private TextInputEditText etImpacto;
    private Button btnGuardar;
    private int idUsuario;
    private final String URL_GET = "http://74.208.75.82/api/get_usuario.php?id=";
    private final String URL_UPDATE = "http://74.208.75.82/api/update_usuario.php";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_perfil);
        SharedPreferences sp = this.getSharedPreferences("userData", 0);
        this.idUsuario = sp.getInt("user_id", -1);
        if (this.idUsuario <= 0) {
            Toast.makeText((Context)this, (CharSequence)"No hay sesi\u00f3n activa", (int)0).show();
            this.finish();
            return;
        }
        this.initViews();
        this.cargarDatos();
        this.btnGuardar.setOnClickListener(v -> this.guardarCambios());
    }

    private void initViews() {
        this.tvNombre = (TextView)this.findViewById(R.id.tvNombre);
        this.txtEmail = (TextView)this.findViewById(R.id.txtEmail);
        this.txtFecha = (TextView)this.findViewById(R.id.txtFecha);
        this.etTelefono = (TextInputEditText)this.findViewById(R.id.etTelefono);
        this.etDireccion = (TextInputEditText)this.findViewById(R.id.etDireccion);
        this.etPuntos = (TextInputEditText)this.findViewById(R.id.etPuntos);
        this.etKilos = (TextInputEditText)this.findViewById(R.id.etKilos);
        this.etImpacto = (TextInputEditText)this.findViewById(R.id.etImpacto);
        this.btnGuardar = (Button)this.findViewById(R.id.btnGuardar);
    }

    private void cargarDatos() {
        StringRequest req = new StringRequest(0, "http://74.208.75.82/api/get_usuario.php?id=" + this.idUsuario, response -> {
            try {
                JSONObject json = new JSONObject(response);
                if (json.optBoolean("error")) {
                    Toast.makeText((Context)this, (CharSequence)json.optString("message", "Error"), (int)0).show();
                    return;
                }
                JSONObject o = json.getJSONObject("user");
                this.tvNombre.setText((CharSequence)o.optString("nombre", ""));
                this.txtEmail.setText((CharSequence)o.optString("email", ""));
                this.etTelefono.setText((CharSequence)o.optString("telefono", ""));
                this.etDireccion.setText((CharSequence)o.optString("direccion", ""));
                this.etPuntos.setText((CharSequence)o.optString("puntos", "0"));
                this.txtFecha.setText((CharSequence)o.optString("fecha_registro", ""));
                this.etKilos.setText((CharSequence)o.optString("kilos_reciclados", "0"));
                this.etImpacto.setText((CharSequence)o.optString("impacto_semanal", "0"));
            }
            catch (Exception e) {
                Toast.makeText((Context)this, (CharSequence)"Error leyendo datos", (int)0).show();
            }
        }, error -> Toast.makeText((Context)this, (CharSequence)"Error conectando al servidor", (int)0).show());
        Volley.newRequestQueue((Context)this).add((Request)req);
    }

    private void guardarCambios() {
        StringRequest req = new StringRequest(1, "http://74.208.75.82/api/update_usuario.php", response -> {
            try {
                JSONObject json = new JSONObject(response);
                if (!json.getBoolean("error")) {
                    Toast.makeText((Context)this, (CharSequence)"Datos actualizados", (int)0).show();
                } else {
                    Toast.makeText((Context)this, (CharSequence)json.optString("message", "Error al actualizar"), (int)0).show();
                }
            }
            catch (Exception e) {
                Toast.makeText((Context)this, (CharSequence)"Error leyendo respuesta", (int)0).show();
            }
        }, error -> Toast.makeText((Context)this, (CharSequence)"Error guardando", (int)0).show()){

            protected Map<String, String> getParams() {
                HashMap<String, String> p = new HashMap<String, String>();
                p.put("id", String.valueOf(PerfilActivity.this.idUsuario));
                p.put("telefono", PerfilActivity.this.etTelefono.getText().toString().trim());
                p.put("direccion", PerfilActivity.this.etDireccion.getText().toString().trim());
                return p;
            }
        };
        Volley.newRequestQueue((Context)this).add((Request)req);
    }
}

