/*
 * Decompiled with CFR 0.152.
 */
package com.chemastudios.ecorecolector;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.text.Editable;
import android.text.TextWatcher;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import com.chemastudios.ecorecolector.R;
import com.google.android.libraries.places.api.Places;
import com.google.android.libraries.places.api.model.AutocompletePrediction;
import com.google.android.libraries.places.api.model.AutocompleteSessionToken;
import com.google.android.libraries.places.api.net.FindAutocompletePredictionsRequest;
import com.google.android.libraries.places.api.net.PlacesClient;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

public class Registros
extends AppCompatActivity {
    private EditText etNombre;
    private EditText etTelefono;
    private EditText etEmail;
    private EditText etPassword;
    private EditText etConfirmPassword;
    private AutoCompleteTextView etDireccion;
    private Button btnRegistrar;
    private PlacesClient placesClient;
    private ArrayAdapter<String> placesAdapter;
    private final List<String> suggestions = new ArrayList<String>();
    private final Handler handler = new Handler();
    private Runnable workRunnable;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.register_app);
        if (!Places.isInitialized()) {
            Places.initialize((Context)this.getApplicationContext(), (String)this.getString(R.string.google_maps_key));
        }
        this.placesClient = Places.createClient((Context)this);
        this.etNombre = (EditText)this.findViewById(R.id.etNombre);
        this.etTelefono = (EditText)this.findViewById(R.id.etTelefono);
        this.etDireccion = (AutoCompleteTextView)this.findViewById(R.id.etDireccion);
        this.etEmail = (EditText)this.findViewById(R.id.etEmail);
        this.etPassword = (EditText)this.findViewById(R.id.etPassword);
        this.etConfirmPassword = (EditText)this.findViewById(R.id.etConfirmPassword);
        this.btnRegistrar = (Button)this.findViewById(R.id.btnRegistrar);
        this.etEmail.addTextChangedListener(new TextWatcher(){
            private boolean editing = false;
            private final String dominio = "@ecorecolector.com";

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (this.editing) {
                    return;
                }
                this.editing = true;
                String texto = s.toString();
                if (texto.isEmpty()) {
                    this.editing = false;
                    return;
                }
                if (texto.contains("@ecorecolector.com")) {
                    int indexDominio = texto.indexOf("@ecorecolector.com");
                    if (indexDominio != -1 && Registros.this.etEmail.getSelectionStart() > indexDominio) {
                        Registros.this.etEmail.setSelection(indexDominio);
                    }
                } else {
                    if (texto.contains("@")) {
                        texto = texto.substring(0, texto.indexOf("@"));
                    }
                    Registros.this.etEmail.setText((CharSequence)(texto + "@ecorecolector.com"));
                    Registros.this.etEmail.setSelection(texto.length());
                }
                this.editing = false;
            }
        });
        this.placesAdapter = new ArrayAdapter((Context)this, 17367050, this.suggestions);
        this.etDireccion.setAdapter(this.placesAdapter);
        this.etDireccion.setThreshold(1);
        this.etDireccion.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (Registros.this.workRunnable != null) {
                    Registros.this.handler.removeCallbacks(Registros.this.workRunnable);
                }
                Registros.this.workRunnable = () -> Registros.this.fetchPlacesPredictions(s.toString());
                Registros.this.handler.postDelayed(Registros.this.workRunnable, 300L);
            }

            public void afterTextChanged(Editable s) {
            }
        });
        this.btnRegistrar.setOnClickListener(v -> this.registrarUsuario());
    }

    private void fetchPlacesPredictions(String query) {
        if (query.isEmpty()) {
            return;
        }
        AutocompleteSessionToken token = AutocompleteSessionToken.newInstance();
        FindAutocompletePredictionsRequest request = FindAutocompletePredictionsRequest.builder().setSessionToken(token).setQuery(query).build();
        this.placesClient.findAutocompletePredictions(request).addOnSuccessListener(response -> {
            this.suggestions.clear();
            for (AutocompletePrediction prediction : response.getAutocompletePredictions()) {
                this.suggestions.add(prediction.getPrimaryText(null).toString() + " " + prediction.getSecondaryText(null).toString());
            }
            this.placesAdapter.notifyDataSetChanged();
            this.etDireccion.showDropDown();
        }).addOnFailureListener(e -> {
            this.suggestions.clear();
            this.placesAdapter.notifyDataSetChanged();
        });
    }

    private void registrarUsuario() {
        String nombre = this.etNombre.getText().toString().trim();
        String tel = this.etTelefono.getText().toString().trim();
        String dir = this.etDireccion.getText().toString().trim();
        String email = this.etEmail.getText().toString().trim();
        String pass1 = this.etPassword.getText().toString().trim();
        String pass2 = this.etConfirmPassword.getText().toString().trim();
        if (nombre.isEmpty() || tel.isEmpty() || dir.isEmpty() || email.isEmpty() || pass1.isEmpty() || pass2.isEmpty()) {
            Toast.makeText((Context)this, (CharSequence)"Llena todos los campos", (int)0).show();
            return;
        }
        if (!email.endsWith("@ecorecolector.com")) {
            Toast.makeText((Context)this, (CharSequence)"El correo debe terminar en @ecorecolector.com", (int)0).show();
            return;
        }
        if (!pass1.equals(pass2)) {
            Toast.makeText((Context)this, (CharSequence)"Las contrase\u00f1as no coinciden", (int)0).show();
            return;
        }
        new Thread(() -> {
            try {
                URL url = new URL("http://74.208.75.82/register.php");
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("POST");
                conn.setDoOutput(true);
                conn.setDoInput(true);
                String data = "nombre=" + URLEncoder.encode(nombre, "UTF-8") + "&telefono=" + URLEncoder.encode(tel, "UTF-8") + "&direccion=" + URLEncoder.encode(dir, "UTF-8") + "&email=" + URLEncoder.encode(email, "UTF-8") + "&password=" + URLEncoder.encode(pass1, "UTF-8");
                OutputStream os = conn.getOutputStream();
                BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
                bw.write(data);
                bw.flush();
                bw.close();
                os.close();
                int responseCode = conn.getResponseCode();
                if (responseCode == 200) {
                    String linea;
                    BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                    StringBuilder respuesta = new StringBuilder();
                    while ((linea = br.readLine()) != null) {
                        respuesta.append(linea);
                    }
                    br.close();
                    this.runOnUiThread(() -> {
                        Toast.makeText((Context)this, (CharSequence)("Registro exitoso: " + respuesta.toString().trim()), (int)1).show();
                        this.finish();
                    });
                } else {
                    this.runOnUiThread(() -> Toast.makeText((Context)this, (CharSequence)("Error en servidor: " + responseCode), (int)0).show());
                }
                conn.disconnect();
            }
            catch (Exception e) {
                this.runOnUiThread(() -> Toast.makeText((Context)this, (CharSequence)("Error de red/conexi\u00f3n: " + e.getMessage()), (int)1).show());
            }
        }).start();
    }
}

