package com.chemastudios.ecorecolector;

import android.os.Bundle;
import android.os.Handler;
import android.widget.ProgressBar;
import android.widget.TextView;

import androidx.appcompat.app.AppCompatActivity;

import java.util.Random;

public class EsperaActivity extends AppCompatActivity {

    private TextView tvTiempoEstimado, tvMensajeEspera, tvTituloEspera, tvNotaEspera;
    private ProgressBar progressBarEspera;
    private Handler handler = new Handler();
    private Runnable runnable;
    private int tiempoEstimadoSegundos;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_espera);

        tvTiempoEstimado = findViewById(R.id.tvTiempoEstimado);
        tvMensajeEspera = findViewById(R.id.tvMensajeEspera);
        tvTituloEspera = findViewById(R.id.tvTituloEspera);
        tvNotaEspera = findViewById(R.id.tvNotaEspera);
        progressBarEspera = findViewById(R.id.progressBarEspera);

        // Generar tiempo estimado aleatorio entre 3 y 15 minutos
        int[] tiempos = {3,5,6,7,8,9,10,11,12,13,14,15};
        int randomIndex = new Random().nextInt(tiempos.length);
        int tiempoEstimadoMinutos = tiempos[randomIndex];
        tiempoEstimadoSegundos = tiempoEstimadoMinutos * 60;

        tvTiempoEstimado.setText("Tiempo estimado: " + tiempoEstimadoMinutos + " min");

        // Mensaje según tiempo
        if (tiempoEstimadoMinutos <= 5) {
            tvMensajeEspera.setText("Tu recolector llegará muy pronto.");
        } else if (tiempoEstimadoMinutos <= 10) {
            tvMensajeEspera.setText("Por favor, ten paciencia, tu recolector está en camino.");
        } else {
            tvMensajeEspera.setText("El recolector tomará un poco más de tiempo, gracias por esperar.");
        }

        tvNotaEspera.setText("Recuerda separar tus residuos correctamente mientras esperas.");

        // Configurar barra de progreso
        progressBarEspera.setMax(tiempoEstimadoSegundos);
        progressBarEspera.setProgress(0);

        // Iniciar progreso
        startProgress();
    }

    private void startProgress() {
        runnable = new Runnable() {
            int currentProgress = 0;

            @Override
            public void run() {
                if (currentProgress <= tiempoEstimadoSegundos) {
                    progressBarEspera.setProgress(currentProgress);
                    currentProgress++;
                    handler.postDelayed(this, 1000); // actualizar cada segundo
                }
            }
        };
        handler.post(runnable);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        // Evitar memory leaks si la actividad se cierra
        handler.removeCallbacks(runnable);
    }
}

