package com.chemastudios.ecorecolector;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;

public class HistorialSolicitudesAdapter extends RecyclerView.Adapter<HistorialSolicitudesAdapter.ViewHolder> {

    ArrayList<Solicitud> lista;
    private OnItemClickListener listener;

    // ✅ interface para click
    public interface OnItemClickListener {
        void onItemClick(Solicitud solicitud);
    }

    // ✅ para recibir listener desde afuera
    public void setOnItemClickListener(OnItemClickListener listener){
        this.listener = listener;
    }

    public HistorialSolicitudesAdapter(ArrayList<Solicitud> lista) {
        this.lista = lista;
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View v = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.item_solicitud, parent, false);
        return new ViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {

        Solicitud s = lista.get(position);

        holder.txtNombre.setText(s.getNombre());
        holder.txtDireccion.setText(s.getDireccion());
        holder.txtFecha.setText(s.getFechaCreacion());
        holder.txtEstado.setText(s.getEstado());

        holder.itemView.setOnClickListener(v -> {
            if (listener != null){
                listener.onItemClick(s);
            }
        });
    }

    @Override
    public int getItemCount() {
        return lista.size();
    }

    public static class ViewHolder extends RecyclerView.ViewHolder {

        TextView txtNombre, txtDireccion, txtFecha, txtEstado;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);

            txtNombre = itemView.findViewById(R.id.txtNombre);
            txtDireccion = itemView.findViewById(R.id.txtDireccion);
            txtFecha = itemView.findViewById(R.id.txtFecha);
            txtEstado = itemView.findViewById(R.id.txtEstado);
        }
    }
}
