package com.chemastudios.ecorecolector;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.List;

public class ProductoAdapterv1 extends RecyclerView.Adapter<ProductoAdapterv1.ViewHolder> {

    List<Producto> lista;
    OnDeleteClickListener listener;

    public interface OnDeleteClickListener {
        void onDelete(int position);
    }

    public ProductoAdapterv1(List<Producto> lista, OnDeleteClickListener listener) {
        this.lista = lista;
        this.listener = listener;
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View v = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.item_productov3, parent, false);
        return new ViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {

        Producto p = lista.get(position);

        holder.txtCategoria.setText(p.getCategoria());
        holder.txtKilos.setText(p.getKilos() + " kg");
        holder.txtPuntos.setText(p.getPuntosv() + " pts");

        holder.btnBorrar.setOnClickListener(v -> {
            if (listener != null) listener.onDelete(position);
        });
    }

    @Override
    public int getItemCount() {
        return lista.size();
    }

    static class ViewHolder extends RecyclerView.ViewHolder {

        TextView txtCategoria, txtKilos, txtPuntos;
        Button btnBorrar;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);

            txtCategoria = itemView.findViewById(R.id.txtItemCategoria);
            txtKilos     = itemView.findViewById(R.id.txtItemKilos);
            txtPuntos    = itemView.findViewById(R.id.txtItemPuntos);
            btnBorrar    = itemView.findViewById(R.id.btnBorrar);
        }
    }
}
