package com.chemastudios.ecorecolector;

import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;

import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class SolicitudActivity extends AppCompatActivity {

    private EditText etNombre, etDireccion, etCiudad, etColonia, etCP, etNumeroCasa, etReferencia;
    private Button btnEnviar;

    private static final String URL_CREATE_SOLICITUD = "http://74.208.75.82/api/create_solicitud.php"; // Cambia a https si tu servidor tiene SSL válido
    private static final String SHARED_PREFS_NAME = "userData";
    private static final String PREFS_USER_ID_KEY = "user_id";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_solicitud);

        etNombre = findViewById(R.id.etNombre);
        etDireccion = findViewById(R.id.etDireccion);
        etCiudad = findViewById(R.id.etCiudad);
        etColonia = findViewById(R.id.etColonia);
        etCP = findViewById(R.id.etCP);
        etNumeroCasa = findViewById(R.id.etNumeroCasa);
        etReferencia = findViewById(R.id.etReferencia);
        btnEnviar = findViewById(R.id.btnEnviarSolicitud);

        btnEnviar.setOnClickListener(v -> enviarSolicitud());
    }

    private void enviarSolicitud() {
        SharedPreferences prefs = getSharedPreferences(SHARED_PREFS_NAME, MODE_PRIVATE);
        final int userId = prefs.getInt(PREFS_USER_ID_KEY, -1);

        if (userId == -1) {
            Toast.makeText(this, "No hay sesión activa.", Toast.LENGTH_LONG).show();
            return;
        }

        final String nombre = etNombre.getText().toString().trim();
        final String direccion = etDireccion.getText().toString().trim();
        final String ciudad = etCiudad.getText().toString().trim();
        final String colonia = etColonia.getText().toString().trim();
        final String cp = etCP.getText().toString().trim();
        final String numeroCasa = etNumeroCasa.getText().toString().trim();
        final String referencia = etReferencia.getText().toString().trim();

        // Validaciones básicas
        if (nombre.isEmpty() || direccion.isEmpty()) {
            Toast.makeText(this, "Nombre y dirección son obligatorios.", Toast.LENGTH_LONG).show();
            return;
        }

        // 🌟 Validación de Ciudad
        if (!ciudad.equalsIgnoreCase("Ciudad Guzmán")) { // Ignora mayúsculas/minúsculas
            Toast.makeText(this, "Solo se permite Ciudad Guzmán.", Toast.LENGTH_LONG).show();
            return;
        }

        // Deshabilitar botón para prevenir doble envío
        btnEnviar.setEnabled(false);

        // Preparar RequestQueue
        RequestQueue queue = Volley.newRequestQueue(this);

        StringRequest request = new StringRequest(Request.Method.POST, URL_CREATE_SOLICITUD,
                response -> {
                    btnEnviar.setEnabled(true); // Rehabilitar botón
                    try {
                        JSONObject jsonResponse = new JSONObject(response);
                        if (!jsonResponse.getBoolean("error")) {
                            int idSolicitud = jsonResponse.getInt("id_solicitud");
                            Toast.makeText(this, "Solicitud creada. ID: " + idSolicitud, Toast.LENGTH_LONG).show();

                            Intent intent = new Intent(SolicitudActivity.this, EsperaActivity.class);
                            intent.putExtra("idSolicitud", String.valueOf(idSolicitud));
                            startActivity(intent);
                            finish();
                        } else {
                            Toast.makeText(this, "Error: " + jsonResponse.getString("message"), Toast.LENGTH_LONG).show();
                        }
                    } catch (JSONException e) {
                        e.printStackTrace();
                        Toast.makeText(this, "Error en la respuesta del servidor o JSON inválido.", Toast.LENGTH_LONG).show();
                    }
                },
                error -> {
                    btnEnviar.setEnabled(true);
                    Toast.makeText(this, "Error de conexión. Revisa tu internet o el servidor.", Toast.LENGTH_LONG).show();
                }
        ) {
            @Override
            protected Map<String, String> getParams() {
                Map<String, String> params = new HashMap<>();
                params.put("id_usuario", String.valueOf(userId));
                params.put("nombre", nombre);
                params.put("direccion", direccion);
                params.put("ciudad", ciudad);
                params.put("colonia", colonia);
                params.put("cp", cp);
                params.put("numero_casa", numeroCasa);
                params.put("referencia", referencia);
                return params;
            }

            @Override
            public String getBodyContentType() {
                return "application/x-www-form-urlencoded; charset=UTF-8";
            }
        };

        request.setRetryPolicy(new DefaultRetryPolicy(
                10000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT
        ));

        queue.add(request);
    }
}
