package com.chemastudios.ecorecolector;

import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.widget.Toast;

import com.android.volley.Request;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;
import com.google.firebase.encoders.json.BuildConfig;

import org.json.JSONObject;

public class UpdateChecker {

    private static final String URL_VERSION = "http://74.208.75.82/version.json";

    public interface Callback {
        void onNoUpdate();
    }

    public static void check(Context context, Callback callback) {

        StringRequest req = new StringRequest(Request.Method.GET, URL_VERSION,
                resp -> {
                    try {
                        JSONObject obj = new JSONObject(resp);
                        int serverVersion = obj.getInt("versionCode");
                        String url = obj.getString("url");
                        String msg = obj.getString("message");

                        int localVersion = BuildConfig.VERSION_CODE;

                        if (serverVersion > localVersion) {
                            showForceUpdateDialog(context, url, msg);
                        } else {
                            callback.onNoUpdate();
                        }

                    } catch (Exception e) {
                        Toast.makeText(context, "Error al validar actualización", Toast.LENGTH_SHORT).show();
                        callback.onNoUpdate();
                    }
                },
                error -> {
                    Toast.makeText(context, "Error al conectar con servidor", Toast.LENGTH_SHORT).show();
                    callback.onNoUpdate();
                });

        Volley.newRequestQueue(context).add(req);
    }

    private static void showForceUpdateDialog(Context context, String url, String message) {

        new AlertDialog.Builder(context)
                .setTitle("Actualización disponible")
                .setMessage(message)
                .setCancelable(false)
                .setPositiveButton("Actualizar", (dialog, which) -> {
                    Intent i = new Intent(Intent.ACTION_VIEW, Uri.parse(url));
                    context.startActivity(i);

                    System.exit(0);  // Fuerza cierre
                })
                .show();
    }
}
