/*
 * Decompiled with CFR 0.152.
 */
package com.chemastudios.ecorecolector;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.chemastudios.ecorecolector.R;
import com.chemastudios.ecorecolector.Solicitud;
import java.util.ArrayList;

public class HistorialSolicitudesAdapter
extends RecyclerView.Adapter<ViewHolder> {
    ArrayList<Solicitud> lista;
    private OnItemClickListener listener;

    public void setOnItemClickListener(OnItemClickListener listener) {
        this.listener = listener;
    }

    public HistorialSolicitudesAdapter(ArrayList<Solicitud> lista) {
        this.lista = lista;
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_solicitud, parent, false);
        return new ViewHolder(v);
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        Solicitud s = this.lista.get(position);
        holder.txtNombre.setText((CharSequence)s.getNombre());
        holder.txtDireccion.setText((CharSequence)s.getDireccion());
        holder.txtFecha.setText((CharSequence)s.getFechaCreacion());
        holder.txtEstado.setText((CharSequence)s.getEstado());
        holder.itemView.setOnClickListener(v -> {
            if (this.listener != null) {
                this.listener.onItemClick(s);
            }
        });
    }

    public int getItemCount() {
        return this.lista.size();
    }

    public static interface OnItemClickListener {
        public void onItemClick(Solicitud var1);
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        TextView txtNombre;
        TextView txtDireccion;
        TextView txtFecha;
        TextView txtEstado;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            this.txtNombre = (TextView)itemView.findViewById(R.id.txtNombre);
            this.txtDireccion = (TextView)itemView.findViewById(R.id.txtDireccion);
            this.txtFecha = (TextView)itemView.findViewById(R.id.txtFecha);
            this.txtEstado = (TextView)itemView.findViewById(R.id.txtEstado);
        }
    }
}

