/*
 * Decompiled with CFR 0.152.
 */
package com.chemastudios.ecorecolector;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.chemastudios.ecorecolector.Producto;
import com.chemastudios.ecorecolector.R;
import java.util.List;

public class ProductoAdapterv1
extends RecyclerView.Adapter<ViewHolder> {
    List<Producto> lista;
    OnDeleteClickListener listener;

    public ProductoAdapterv1(List<Producto> lista, OnDeleteClickListener listener) {
        this.lista = lista;
        this.listener = listener;
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_productov3, parent, false);
        return new ViewHolder(v);
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        Producto p = this.lista.get(position);
        holder.txtCategoria.setText((CharSequence)p.getCategoria());
        holder.txtKilos.setText((CharSequence)(p.getKilos() + " kg"));
        holder.txtPuntos.setText((CharSequence)(p.getPuntosv() + " pts"));
        holder.btnBorrar.setOnClickListener(v -> {
            if (this.listener != null) {
                this.listener.onDelete(position);
            }
        });
    }

    public int getItemCount() {
        return this.lista.size();
    }

    public static interface OnDeleteClickListener {
        public void onDelete(int var1);
    }

    static class ViewHolder
    extends RecyclerView.ViewHolder {
        TextView txtCategoria;
        TextView txtKilos;
        TextView txtPuntos;
        Button btnBorrar;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            this.txtCategoria = (TextView)itemView.findViewById(R.id.txtItemCategoria);
            this.txtKilos = (TextView)itemView.findViewById(R.id.txtItemKilos);
            this.txtPuntos = (TextView)itemView.findViewById(R.id.txtItemPuntos);
            this.btnBorrar = (Button)itemView.findViewById(R.id.btnBorrar);
        }
    }
}

