package com.chemastudios.ecorecolector;

import android.content.Intent;
import android.os.Bundle;
import android.widget.Toast;
import com.google.android.material.textfield.TextInputEditText;
import com.google.android.material.button.MaterialButton;

import androidx.appcompat.app.AppCompatActivity;

import com.android.volley.Request;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;

import java.util.HashMap;
import java.util.Map;

public class ConfirmarDatosActivity extends AppCompatActivity {

    TextInputEditText txtNombre, txtTelefono, txtDireccion;
    MaterialButton btnFinalizar;

    String producto;
    int costo;

    String URL_CANJEAR = "http://74.208.75.82/api/canjear_producto.php";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_confirmar_datos);

        txtNombre = findViewById(R.id.txtNombre);
        txtTelefono = findViewById(R.id.txtTelefono);
        txtDireccion = findViewById(R.id.txtDireccion);
        btnFinalizar = findViewById(R.id.btnFinalizar);

        producto = getIntent().getStringExtra("producto");
        costo = getIntent().getIntExtra("costo", 0);

        btnFinalizar.setOnClickListener(v -> enviarCanje());
    }

    private void enviarCanje() {

        int idUser = SessionManager.getUserId();

        StringRequest req = new StringRequest(Request.Method.POST, URL_CANJEAR,
                resp -> {
                    Toast.makeText(this, "✅ Canje realizado", Toast.LENGTH_SHORT).show();

                    Intent i = new Intent(this, CanjeoActivity.class);
                    startActivity(i);
                    finish();
                },
                error -> Toast.makeText(this, "Error al canjear", Toast.LENGTH_SHORT).show()
        ) {
            @Override
            protected Map<String, String> getParams() {
                Map<String, String> p = new HashMap<>();

                p.put("id_usuario", String.valueOf(idUser));
                p.put("producto", producto);
                p.put("costo", String.valueOf(costo));
                p.put("nombre", txtNombre.getText().toString());
                p.put("telefono", txtTelefono.getText().toString());
                p.put("direccion", txtDireccion.getText().toString());

                return p;
            }
        };

        Volley.newRequestQueue(this).add(req);
    }
}

