package com.chemastudios.ecorecolector;

import android.content.SharedPreferences;
import android.os.Bundle;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;

import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;

import java.util.HashMap;
import java.util.Map;

public class FormularioCompraActivity extends AppCompatActivity {

    EditText edtNombre, edtTelefono, edtDireccion;
    Button btnEnviar;

    String producto;
    int costo;

    String URL_REGISTRO = "http://74.208.75.82/api/registrar_compra.php";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_formulario);

        edtNombre = findViewById(R.id.edtNombre);
        edtTelefono = findViewById(R.id.edtTelefono);
        edtDireccion = findViewById(R.id.edtDireccion);
        btnEnviar = findViewById(R.id.btnEnviar);

        producto = getIntent().getStringExtra("nombre");
        costo = getIntent().getIntExtra("costo", 0);

        btnEnviar.setOnClickListener(v -> registrarCompra());
    }

    private void registrarCompra() {

        SharedPreferences prefs = getSharedPreferences("user_data", MODE_PRIVATE);
        int id_usuario = prefs.getInt("id", -1);

        StringRequest request = new StringRequest(Request.Method.POST, URL_REGISTRO,
                response -> {
                    Toast.makeText(this, "Compra registrada", Toast.LENGTH_SHORT).show();
                    finish();
                }, error -> {
            Toast.makeText(this, "Error: " + error.toString(), Toast.LENGTH_SHORT).show();
        }) {
            @Override
            protected Map<String, String> getParams() {
                Map<String, String> params = new HashMap<>();
                params.put("id_usuario", String.valueOf(id_usuario));
                params.put("nombre", edtNombre.getText().toString());
                params.put("telefono", edtTelefono.getText().toString());
                params.put("direccion", edtDireccion.getText().toString());
                params.put("producto", producto);
                params.put("costo", String.valueOf(costo));
                return params;
            }
        };

        RequestQueue queue = Volley.newRequestQueue(FormularioCompraActivity.this);
        queue.add(request);
    }
}
