package com.chemastudios.ecorecolector;

import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;

import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.google.android.material.card.MaterialCardView;

public class RecolectorActivity extends AppCompatActivity {

    // Nombres de las Activities simuladas para navegación
    // *Asegúrate de que estas clases existan en tu proyecto.*
    private static final Class<?> RESIDUOS_ACTIVITY = ResiduosActivity.class;
    private static final Class<?> APRENDER_RECICLAJE_ACTIVITY = AprenderReciclajeActivity.class;
    private static final Class<?> NOTICIAS_ACTIVITY = NoticiasActivity.class;
    private static final Class<?> INTERESANTES_ACTIVITY = InteresantesActivity.class;

    // Asumo que estas clases son las que ya tienes o quieres usar
    private static final Class<?> LISTA_SOLICITUDES_ACTIVITY = HistorialSolicitudesActivityV1.class;
    private static final Class<?> FORMULARIO_PRODUCTOS_ACTIVITY = DetalleSolicitudActivityV1.class;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.recolector_app);

        ImageView iconMenu = findViewById(R.id.iconMenu);
        iconMenu.setOnClickListener(v -> {
            startActivity(new Intent(RecolectorActivity.this, MenuTrabajadorActivity.class));
        });

        Button btnVerRuta = findViewById(R.id.btnVerRuta);
        btnVerRuta.setOnClickListener(v->{
            startActivity(new Intent(RecolectorActivity.this, HistorialSolicitudesActivityV1.class));
        });

        View reciduostrabajadormanual = findViewById(R.id.manualdereciduos);

        reciduostrabajadormanual.setOnClickListener(v -> {
            startActivity(new Intent(RecolectorActivity.this, VerMasReciclaje.class));
        });
    }
    /**
     * Función auxiliar para simplificar la navegación y el Toast.
     */
    private void navigateToActivity(String toastMessage, Class<?> targetActivity) {
        Toast.makeText(this, toastMessage, Toast.LENGTH_SHORT).show();
        Intent intent = new Intent(RecolectorActivity.this, targetActivity);
        startActivity(intent);
    }


    /**
     * Función que crea y muestra el BottomSheetDialog con el layout de menú mejorado.
     * (Esta función se mantiene igual, solo cambié el nombre de las constantes para claridad).
     */
    private void showInfoBottomSheet() {
        final BottomSheetDialog bottomSheetDialog = new BottomSheetDialog(this);
        View bottomSheetView = LayoutInflater.from(this).inflate(R.layout.bottom_sheet_info_menu, null);

        // Tarjeta 1: Ver Solicitudes (card_contact)
        MaterialCardView cardContact = bottomSheetView.findViewById(R.id.card_contact);
        cardContact.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                navigateToActivity("Navegando a la lista de Solicitudes...", LISTA_SOLICITUDES_ACTIVITY);
                bottomSheetDialog.dismiss();
            }
        });

        // Tarjeta 2: Solicitudes de Productos (card_tutorial)
        MaterialCardView cardTutorial = bottomSheetView.findViewById(R.id.card_tutorial);
        cardTutorial.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                navigateToActivity("Abriendo el formulario de Productos...", FORMULARIO_PRODUCTOS_ACTIVITY);
                bottomSheetDialog.dismiss();
            }
        });

        bottomSheetDialog.setContentView(bottomSheetView);
        bottomSheetDialog.show();
    }
}