/*
 * Decompiled with CFR 0.152.
 */
package com.chemastudios.ecorecolector;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.widget.Button;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import com.android.volley.Request;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;
import com.chemastudios.ecorecolector.ConfirmarDatosActivity;
import com.chemastudios.ecorecolector.R;

public class CanjeoActivity
extends AppCompatActivity {
    int puntosUsuario = 0;
    int idUsuario;
    String URL_PUNTOS = "http://74.208.75.82/api/get_puntos_canjeo.php?id=";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.item_producto);
        SharedPreferences sp = this.getSharedPreferences("userData", 0);
        this.idUsuario = sp.getInt("user_id", -1);
        if (this.idUsuario == -1) {
            Toast.makeText((Context)this, (CharSequence)"No hay sesi\u00f3n activa", (int)0).show();
            this.finish();
            return;
        }
        this.cargarPuntosServidor(() -> {
            this.configurarBoton(R.id.btnCanjearProd1, 100, "Lapicero ecol\u00f3gico");
            this.configurarBoton(R.id.btnCanjearProd2, 125, "Bolsa de algod\u00f3n");
            this.configurarBoton(R.id.btnCanjearProd3, 800, "Kit bamb\u00fa");
            this.configurarBoton(R.id.btnCanjearProd4, 150, "Semillas");
            this.configurarBoton(R.id.btnCanjearProd5, 450, "Cepillo bamb\u00fa");
            this.configurarBoton(R.id.btnCanjearProd6, 1200, "Termo acero");
            this.configurarBoton(R.id.btnCanjearProd7, 600, "Pasta s\u00f3lida");
            this.configurarBoton(R.id.btnCanjearProd8, 2000, "Funda compostable");
            this.configurarBoton(R.id.btnCanjearProd9, 1950, "Shampoo s\u00f3lido");
            this.configurarBoton(R.id.btnCanjearProd10, 1690, "Filtro caf\u00e9");
        });
    }

    private void cargarPuntosServidor(Runnable callback) {
        String url = this.URL_PUNTOS + this.idUsuario;
        StringRequest req = new StringRequest(0, url, resp -> {
            try {
                this.puntosUsuario = Integer.parseInt(resp.trim());
                if (this.puntosUsuario <= 0) {
                    Toast.makeText((Context)this, (CharSequence)"A\u00fan no tienes puntos disponibles", (int)0).show();
                    this.finish();
                    return;
                }
                callback.run();
            }
            catch (Exception e) {
                Toast.makeText((Context)this, (CharSequence)"Error leyendo puntos", (int)0).show();
            }
        }, error -> Toast.makeText((Context)this, (CharSequence)"Error al cargar puntos", (int)0).show());
        Volley.newRequestQueue((Context)this).add((Request)req);
    }

    private void configurarBoton(int idBtn, int costo, String nombreProd) {
        Button btn = (Button)this.findViewById(idBtn);
        btn.setOnClickListener(v -> {
            if (this.puntosUsuario < costo) {
                Toast.makeText((Context)this, (CharSequence)"No tienes suficientes puntos", (int)0).show();
                return;
            }
            Intent i = new Intent((Context)this, ConfirmarDatosActivity.class);
            i.putExtra("producto", nombreProd);
            i.putExtra("costo", costo);
            this.startActivity(i);
        });
    }
}

