/*
 * Decompiled with CFR 0.152.
 */
package com.chemastudios.ecorecolector;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ListView;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import com.chemastudios.ecorecolector.ConexionWeb;
import com.chemastudios.ecorecolector.LimiteDiaActivity;
import com.chemastudios.ecorecolector.R;
import com.chemastudios.ecorecolector.SessionManager;
import com.google.zxing.integration.android.IntentIntegrator;
import com.google.zxing.integration.android.IntentResult;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class ScanProductosActivity
extends AppCompatActivity {
    private Button btnScan;
    private Button btnObtenerPuntos;
    private ListView listView;
    private ArrayList<String> productos = new ArrayList();
    private ArrayAdapter<String> adapter;
    private int puntosTotal = 0;
    private final int puntosPorProducto = 5;
    private final int LIMITE_DIARIO = 10;
    private SharedPreferences prefs;
    private String fechaHoy = "";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_scan_productos);
        this.btnScan = (Button)this.findViewById(R.id.btnScan);
        this.btnObtenerPuntos = (Button)this.findViewById(R.id.btnObtenerPuntos);
        this.listView = (ListView)this.findViewById(R.id.listViewProductos);
        this.adapter = new ArrayAdapter((Context)this, 17367043, this.productos);
        this.listView.setAdapter(this.adapter);
        this.prefs = this.getSharedPreferences("LIMITE_SCAN", 0);
        this.verificarDia();
        this.btnScan.setOnClickListener(v -> this.iniciarScanner());
        this.btnObtenerPuntos.setOnClickListener(v -> this.enviarPuntos());
    }

    private void verificarDia() {
        this.fechaHoy = new SimpleDateFormat("yyyyMMdd").format(new Date());
        String fechaGuardada = this.prefs.getString("fecha", "");
        if (!this.fechaHoy.equals(fechaGuardada)) {
            this.prefs.edit().putString("fecha", this.fechaHoy).putInt("contador", 0).apply();
        }
    }

    private int getContadorHoy() {
        return this.prefs.getInt("contador", 0);
    }

    private void incrementarContador() {
        this.prefs.edit().putInt("contador", this.getContadorHoy() + 1).apply();
    }

    private void iniciarScanner() {
        if (this.getContadorHoy() >= 10) {
            this.startActivity(new Intent((Context)this, LimiteDiaActivity.class));
            return;
        }
        IntentIntegrator integrator = new IntentIntegrator((Activity)this);
        integrator.setDesiredBarcodeFormats(IntentIntegrator.ALL_CODE_TYPES);
        integrator.setPrompt("Escanea el c\u00f3digo");
        integrator.setBeepEnabled(true);
        integrator.initiateScan();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        IntentResult result = IntentIntegrator.parseActivityResult((int)requestCode, (int)resultCode, (Intent)data);
        if (result != null && result.getContents() != null) {
            if (this.getContadorHoy() >= 10) {
                this.startActivity(new Intent((Context)this, LimiteDiaActivity.class));
                return;
            }
            String producto = result.getContents();
            this.productos.add(producto);
            this.adapter.notifyDataSetChanged();
            this.puntosTotal += 5;
            this.incrementarContador();
            Toast.makeText((Context)this, (CharSequence)"Producto + 5 pts", (int)0).show();
        } else {
            super.onActivityResult(requestCode, resultCode, data);
        }
    }

    private void enviarPuntos() {
        int userId = SessionManager.getUserId();
        if (userId == -1) {
            Toast.makeText((Context)this, (CharSequence)"Error: Usuario no logueado", (int)1).show();
            return;
        }
        if (this.puntosTotal == 0) {
            Toast.makeText((Context)this, (CharSequence)"No tienes puntos para enviar", (int)0).show();
            return;
        }
        new Thread(() -> {
            String respuesta = ConexionWeb.enviarPuntos(String.valueOf(userId), this.puntosTotal);
            this.runOnUiThread(() -> {
                Toast.makeText((Context)this, (CharSequence)respuesta, (int)1).show();
                this.productos.clear();
                this.adapter.notifyDataSetChanged();
                this.puntosTotal = 0;
            });
        }).start();
    }
}

