/*
 * Decompiled with CFR 0.152.
 */
package com.chemastudios.ecorecolector;

import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.widget.Toast;
import com.android.volley.Request;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;
import org.json.JSONObject;

public class UpdateChecker {
    private static final String URL_VERSION = "http://74.208.75.82/version.json";

    public static void check(Context context, Callback callback) {
        StringRequest req = new StringRequest(0, URL_VERSION, resp -> {
            try {
                JSONObject obj = new JSONObject(resp);
                int serverVersion = obj.getInt("versionCode");
                String url = obj.getString("url");
                String msg = obj.getString("message");
                int localVersion = -1;
                if (serverVersion > localVersion) {
                    UpdateChecker.showForceUpdateDialog(context, url, msg);
                } else {
                    callback.onNoUpdate();
                }
            }
            catch (Exception e) {
                Toast.makeText((Context)context, (CharSequence)"Error al validar actualizaci\u00f3n", (int)0).show();
                callback.onNoUpdate();
            }
        }, error -> {
            Toast.makeText((Context)context, (CharSequence)"Error al conectar con servidor", (int)0).show();
            callback.onNoUpdate();
        });
        Volley.newRequestQueue((Context)context).add((Request)req);
    }

    private static void showForceUpdateDialog(Context context, String url, String message) {
        new AlertDialog.Builder(context).setTitle((CharSequence)"Actualizaci\u00f3n disponible").setMessage((CharSequence)message).setCancelable(false).setPositiveButton((CharSequence)"Actualizar", (dialog, which) -> {
            Intent i = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            context.startActivity(i);
            System.exit(0);
        }).show();
    }

    public static interface Callback {
        public void onNoUpdate();
    }
}

