plugins {
    alias(libs.plugins.android.application)
}

android {
    namespace = "com.chemastudios.ecorecolector"
    compileSdk = 35

    defaultConfig {
        applicationId = "com.chemastudios.ecorecolector"
        minSdk = 23              // Android 6.0
        targetSdk = 35           // Android 15+
        versionCode = 1
        versionName = "1.1"

        testInstrumentationRunner = "androidx.test.runner.AndroidJUnitRunner"
    }

    buildTypes {
        release {
            isMinifyEnabled = false
            proguardFiles(
                getDefaultProguardFile("proguard-android-optimize.txt"),
                "proguard-rules.pro"
            )
        }
    }

    compileOptions {
        sourceCompatibility = JavaVersion.VERSION_11
        targetCompatibility = JavaVersion.VERSION_11
    }

    buildFeatures {
        viewBinding = true
    }
}

dependencies {

    // ---- ANDROIDX ----
    implementation(libs.appcompat)
    implementation(libs.androidx.core.ktx)
    implementation(libs.constraintlayout)

    // ---- MATERIAL ----
    implementation(libs.material)

    // ---- LIFECYCLE ----
    implementation(libs.lifecycle.livedata.ktx)
    implementation(libs.lifecycle.viewmodel.ktx)
    implementation(libs.androidx.lifecycle.runtime.ktx)

    // ---- NAVIGATION ----
    implementation(libs.navigation.fragment)
    implementation(libs.navigation.ui)

    // ---- GLIDE ----
    implementation(libs.glide)
    annotationProcessor(libs.glideCompiler)

    // ---- ZXING CODE SCANNER ----
    implementation(libs.zxing)

    // ---- GOOGLE MAPS / PLACES ----
    implementation(libs.google.maps)
    implementation(libs.google.places)

    // ---- TESTS ----
    testImplementation(libs.junit)
    androidTestImplementation(libs.ext.junit)
    androidTestImplementation(libs.espresso.core)

    implementation(libs.hdodenhof.circleimageview)
}
