package com.chemastudios.ecorecolector;

import android.content.SharedPreferences;
import android.os.Bundle;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;

import com.android.volley.Request;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;
import com.google.android.material.textfield.TextInputEditText;

import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class PerfilActivity extends AppCompatActivity {

    private TextView tvNombre, txtEmail, txtFecha;
    private TextInputEditText etTelefono, etDireccion;
    private TextInputEditText etPuntos, etKilos, etImpacto;
    private Button btnGuardar;

    private int idUsuario;

    private final String URL_GET = "http://74.208.75.82/api/get_usuario.php?id=";
    private final String URL_UPDATE = "http://74.208.75.82/api/update_usuario.php";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_perfil);

        SharedPreferences sp = getSharedPreferences("userData", MODE_PRIVATE);
        idUsuario = sp.getInt("user_id", -1);

        if (idUsuario <= 0) {
            Toast.makeText(this, "No hay sesión activa", Toast.LENGTH_SHORT).show();
            finish();
            return;
        }

        initViews();
        cargarDatos();

        btnGuardar.setOnClickListener(v -> guardarCambios());
    }

    private void initViews() {

        tvNombre = findViewById(R.id.tvNombre);
        txtEmail = findViewById(R.id.txtEmail);
        txtFecha = findViewById(R.id.txtFecha);

        etTelefono = findViewById(R.id.etTelefono);
        etDireccion = findViewById(R.id.etDireccion);

        etPuntos = findViewById(R.id.etPuntos);
        etKilos = findViewById(R.id.etKilos);
        etImpacto = findViewById(R.id.etImpacto);

        btnGuardar = findViewById(R.id.btnGuardar);
    }

    private void cargarDatos() {

        StringRequest req = new StringRequest(Request.Method.GET, URL_GET + idUsuario,
                response -> {
                    try {

                        JSONObject json = new JSONObject(response);

                        if (json.optBoolean("error")) {
                            Toast.makeText(this, json.optString("message", "Error"), Toast.LENGTH_SHORT).show();
                            return;
                        }

                        JSONObject o = json.getJSONObject("user");

                        tvNombre.setText(o.optString("nombre", ""));
                        txtEmail.setText(o.optString("email", ""));

                        etTelefono.setText(o.optString("telefono", ""));
                        etDireccion.setText(o.optString("direccion", ""));

                        etPuntos.setText(o.optString("puntos", "0"));
                        txtFecha.setText(o.optString("fecha_registro", ""));

                        etKilos.setText(o.optString("kilos_reciclados", "0"));
                        etImpacto.setText(o.optString("impacto_semanal", "0"));

                    } catch (Exception e) {
                        Toast.makeText(this, "Error leyendo datos", Toast.LENGTH_SHORT).show();
                    }
                },
                error -> Toast.makeText(this, "Error conectando al servidor", Toast.LENGTH_SHORT).show()
        );

        Volley.newRequestQueue(this).add(req);
    }

    private void guardarCambios() {

        StringRequest req = new StringRequest(Request.Method.POST, URL_UPDATE,
                response -> {
                    try {
                        JSONObject json = new JSONObject(response);
                        if (!json.getBoolean("error")) {
                            Toast.makeText(this, "Datos actualizados", Toast.LENGTH_SHORT).show();
                        } else {
                            Toast.makeText(this, json.optString("message", "Error al actualizar"), Toast.LENGTH_SHORT).show();
                        }
                    } catch (Exception e) {
                        Toast.makeText(this, "Error leyendo respuesta", Toast.LENGTH_SHORT).show();
                    }
                },
                error -> Toast.makeText(this, "Error guardando", Toast.LENGTH_SHORT).show()
        ) {
            @Override
            protected Map<String, String> getParams() {
                Map<String, String> p = new HashMap<>();
                p.put("id", String.valueOf(idUsuario));
                p.put("telefono", etTelefono.getText().toString().trim());
                p.put("direccion", etDireccion.getText().toString().trim());
                return p;
            }
        };

        Volley.newRequestQueue(this).add(req);
    }
}
