package com.chemastudios.ecorecolector;

import androidx.appcompat.app.AppCompatActivity;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ListView;
import android.widget.Toast;

import com.google.zxing.integration.android.IntentIntegrator;
import com.google.zxing.integration.android.IntentResult;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class ScanProductosActivity extends AppCompatActivity {

    private Button btnScan, btnObtenerPuntos;
    private ListView listView;
    private ArrayList<String> productos = new ArrayList<>();
    private ArrayAdapter<String> adapter;

    private int puntosTotal = 0;
    private final int puntosPorProducto = 5;

    private final int LIMITE_DIARIO = 10;

    private SharedPreferences prefs;
    private String fechaHoy = "";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_scan_productos);

        btnScan = findViewById(R.id.btnScan);
        btnObtenerPuntos = findViewById(R.id.btnObtenerPuntos);
        listView = findViewById(R.id.listViewProductos);

        adapter = new ArrayAdapter<>(this, android.R.layout.simple_list_item_1, productos);
        listView.setAdapter(adapter);

        prefs = getSharedPreferences("LIMITE_SCAN", Context.MODE_PRIVATE);

        verificarDia();

        btnScan.setOnClickListener(v -> iniciarScanner());
        btnObtenerPuntos.setOnClickListener(v -> enviarPuntos());
    }

    private void verificarDia() {
        fechaHoy = new SimpleDateFormat("yyyyMMdd").format(new Date());
        String fechaGuardada = prefs.getString("fecha", "");

        if (!fechaHoy.equals(fechaGuardada)) {
            prefs.edit()
                    .putString("fecha", fechaHoy)
                    .putInt("contador", 0)
                    .apply();
        }
    }

    private int getContadorHoy() {
        return prefs.getInt("contador", 0);
    }

    private void incrementarContador() {
        prefs.edit()
                .putInt("contador", getContadorHoy() + 1)
                .apply();
    }

    private void iniciarScanner() {
        if (getContadorHoy() >= LIMITE_DIARIO) {
            startActivity(new Intent(this, LimiteDiaActivity.class));
            return;
        }

        IntentIntegrator integrator = new IntentIntegrator(this);
        integrator.setDesiredBarcodeFormats(IntentIntegrator.ALL_CODE_TYPES);
        integrator.setPrompt("Escanea el código");
        integrator.setBeepEnabled(true);
        integrator.initiateScan();
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        IntentResult result = IntentIntegrator.parseActivityResult(requestCode, resultCode, data);

        if (result != null && result.getContents() != null) {

            if (getContadorHoy() >= LIMITE_DIARIO) {
                startActivity(new Intent(this, LimiteDiaActivity.class));
                return;
            }

            String producto = result.getContents();
            productos.add(producto);
            adapter.notifyDataSetChanged();

            puntosTotal += puntosPorProducto;
            incrementarContador();

            Toast.makeText(this, "Producto + " + puntosPorProducto + " pts", Toast.LENGTH_SHORT).show();

        } else {
            super.onActivityResult(requestCode, resultCode, data);
        }
    }

    private void enviarPuntos() {
        int userId = SessionManager.getUserId(); // ✅ Obtener el ID real del usuario

        if (userId == -1) {
            Toast.makeText(this, "Error: Usuario no logueado", Toast.LENGTH_LONG).show();
            return;
        }

        if (puntosTotal == 0) {
            Toast.makeText(this, "No tienes puntos para enviar", Toast.LENGTH_SHORT).show();
            return;
        }

        new Thread(() -> {
            // Aquí se envían los puntos reales al campo "puntos" del usuario en MySQL
            String respuesta = ConexionWeb.enviarPuntos(String.valueOf(userId), puntosTotal);

            runOnUiThread(() -> {
                Toast.makeText(this, respuesta, Toast.LENGTH_LONG).show();
                productos.clear();
                adapter.notifyDataSetChanged();
                puntosTotal = 0;
            });

        }).start();
    }
}


