package com.chemastudios.ecorecolector;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.widget.Button;
import android.widget.TextView;

import androidx.appcompat.app.AppCompatActivity;

public class VerMapa extends AppCompatActivity {

    TextView txtNombre, txtReferencia, txtDireccion, txtTelefono;
    Button btnVerDireccion, btnVerTelefono, btnDarPuntos; // Nuevo botón agregado

    String direccionCompleta, telefono, idSolicitud, idUsuario;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_ver_mapa);

        txtNombre = findViewById(R.id.txtNombre);
        txtReferencia = findViewById(R.id.txtReferencia);
        txtDireccion = findViewById(R.id.txtDireccion);
        txtTelefono = findViewById(R.id.txtTelefono);
        btnVerDireccion = findViewById(R.id.btnVerDireccion);
        btnVerTelefono = findViewById(R.id.btnVerTelefono);
        btnDarPuntos = findViewById(R.id.btnDarPuntos); // Referencia al botón

        // Obtener datos enviados por intent
        String nombre = getIntent().getStringExtra("nombre");
        String referencia = getIntent().getStringExtra("referencia");
        String direccion = getIntent().getStringExtra("direccion");
        String ciudad = getIntent().getStringExtra("ciudad");
        String colonia = getIntent().getStringExtra("colonia");
        String cp = getIntent().getStringExtra("cp");
        String numeroCasa = getIntent().getStringExtra("numeroCasa");
        telefono = getIntent().getStringExtra("telefono");
        idSolicitud = getIntent().getStringExtra("idSolicitud");
        idUsuario = getIntent().getStringExtra("idUsuario");

        // Formatear dirección completa
        direccionCompleta = direccion + ", " + numeroCasa + ", " + colonia + ", " + ciudad + ", CP: " + cp;

        // Mostrar datos en los TextViews
        txtNombre.setText("Nombre: " + nombre);
        txtReferencia.setText("Referencia: " + referencia);
        txtDireccion.setText("Dirección: " + direccionCompleta);
        txtTelefono.setText("Teléfono: " + (telefono != null && !telefono.isEmpty() ? "**********" : "No disponible"));

        // Abrir Google Maps al presionar btnVerDireccion
        btnVerDireccion.setOnClickListener(v -> {
            Uri gmmIntentUri = Uri.parse("geo:0,0?q=" + Uri.encode(direccionCompleta));
            Intent mapIntent = new Intent(Intent.ACTION_VIEW, gmmIntentUri);
            mapIntent.setPackage("com.google.android.apps.maps");
            startActivity(mapIntent);
        });

        // Llamar al cliente al presionar btnVerTelefono
        btnVerTelefono.setOnClickListener(v -> {
            if (telefono != null && !telefono.isEmpty()) {
                Intent intent = new Intent(Intent.ACTION_DIAL);
                intent.setData(Uri.parse("tel:" + telefono));
                startActivity(intent);
            }
        });

        // Abrir DetallesSolicitudActivityV1 al presionar btnDarPuntos
        btnDarPuntos.setOnClickListener(v -> {
            Intent intent = new Intent(VerMapa.this, DetalleSolicitudActivityV1.class);
            // Pasamos la información necesaria
            intent.putExtra("idSolicitud", idSolicitud);
            intent.putExtra("idUsuario", idUsuario);
            intent.putExtra("nombre", nombre);
            intent.putExtra("direccion", direccion);
            intent.putExtra("ciudad", ciudad);
            intent.putExtra("colonia", colonia);
            intent.putExtra("cp", cp);
            intent.putExtra("numeroCasa", numeroCasa);
            intent.putExtra("referencia", referencia);
            intent.putExtra("telefono", telefono);

            startActivity(intent);
        });
    }
}
